
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * This notice applies to any and all portions of this file
  * that are not between comment pairs USER CODE BEGIN and
  * USER CODE END. Other portions of this file, whether 
  * inserted by the user or by software development tools
  * are owned by their respective copyright owners.
  *
  * Copyright (c) 2019 STMicroelectronics International N.V. 
  * All rights reserved.
  *
  * Redistribution and use in source and binary forms, with or without 
  * modification, are permitted, provided that the following conditions are met:
  *
  * 1. Redistribution of source code must retain the above copyright notice, 
  *    this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright notice,
  *    this list of conditions and the following disclaimer in the documentation
  *    and/or other materials provided with the distribution.
  * 3. Neither the name of STMicroelectronics nor the names of other 
  *    contributors to this software may be used to endorse or promote products 
  *    derived from this software without specific written permission.
  * 4. This software, including modifications and/or derivative works of this 
  *    software, must execute solely and exclusively on microcontroller or
  *    microprocessor devices manufactured by or for STMicroelectronics.
  * 5. Redistribution and use of this software other than as permitted under 
  *    this license is void and will automatically terminate your rights under 
  *    this license. 
  *
  * THIS SOFTWARE IS PROVIDED BY STMICROELECTRONICS AND CONTRIBUTORS "AS IS" 
  * AND ANY EXPRESS, IMPLIED OR STATUTORY WARRANTIES, INCLUDING, BUT NOT 
  * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
  * PARTICULAR PURPOSE AND NON-INFRINGEMENT OF THIRD PARTY INTELLECTUAL PROPERTY
  * RIGHTS ARE DISCLAIMED TO THE FULLEST EXTENT PERMITTED BY LAW. IN NO EVENT 
  * SHALL STMICROELECTRONICS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
  * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
  * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
  * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "stm32l0xx_hal.h"
#include "cmsis_os.h"

/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Private variables ---------------------------------------------------------*/
UART_HandleTypeDef hlpuart1;
UART_HandleTypeDef huart2;

osThreadId defaultTaskHandle;
osThreadId myTaskUART1Handle;
osThreadId myTaskUART2Handle;

/* USER CODE BEGIN PV */
/* Private variables ---------------------------------------------------------*/

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
static void MX_USART2_UART_Init(void);
static void MX_LPUART1_UART_Init(void);
void StartDefaultTask(void const * argument);
void StartTaskUART1(void const * argument);
void StartTaskUART2(void const * argument);
static void MX_NVIC_Init(void);

/* USER CODE BEGIN PFP */
/* Private function prototypes -----------------------------------------------*/

/* USER CODE END PFP */

/* USER CODE BEGIN 0 */

#define u8 unsigned char
#define u16 unsigned short
#define u32 unsigned long
#define RX_Length 100

#ifdef __GNUC__
/* With GCC, small printf (option LD Linker->Libraries->Small printf
   set to 'Yes') calls __io_putchar() */
#define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
#define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#endif /* __GNUC__ */


#define MONITOR_QUEUE_SIZE					( 10 )


xQueueHandle xMonitorQueue;	

typedef struct
{
	u8 Device;
	u16 Value;
	u8  Operation;

} xMonitorMessage;


uint8_t aRxBuffer[20];
uint8_t aRxtemp =0;


static u8  fac_us=0;
static u16 fac_ms=0;
void delay_init(u8 SYSCLK)
{
	SysTick->CTRL&=0xfffffffb;//bit2,ѡⲿʱ  HCLK/8
	fac_us=SYSCLK/8;		    
	fac_ms=(u16)fac_us*1000;
}	

void delay_ms(u16 nms)
{	 		  	  
	u32 temp;		   
	SysTick->LOAD=(u32)nms*fac_ms;//ʱ(SysTick->LOADد24bit)
	SysTick->VAL =0x00;           //ռ
	SysTick->CTRL=0x01 ;          //ʼ߯  
	do
	{
		temp=SysTick->CTRL;
	}
	while(temp&0x01&&!(temp&(1<<16)));//ȴʱ䵽   
	SysTick->CTRL=0x00;       //رռ
	SysTick->VAL =0X00;       //ռ	  	    
}   
//ʱnus
//nusΪҪʱus.		    								   
void delay_us(u32 nus)
{		
	u32 temp;	    	 
	SysTick->LOAD=nus*fac_us; //ʱ	  		 
	SysTick->VAL=0x00;        //ռ
	SysTick->CTRL=0x01 ;      //ʼ߯ 	 
	do
	{
		temp=SysTick->CTRL;
	}
	while(temp&0x01&&!(temp&(1<<16)));//ȴʱ䵽   
	SysTick->CTRL=0x00;       //رռ
	SysTick->VAL =0X00;       //ռ	 
}

PUTCHAR_PROTOTYPE
{
  /* Place your implementation of fputc here */
  /* e.g. write a character to the USART2 and Loop until the end of transmission */
  HAL_UART_Transmit(&huart2, (uint8_t *)&ch, 1, 0xFFFF);

  return ch;
}

#pragma import(__use_no_semihosting)
 
struct __FILE
{
	int a;
};
 
FILE __stdout;
 
void _sys_exit(int x)
{
	
}

unsigned int crc_chk(unsigned char* data, unsigned char length)
{
   int j;
   unsigned int reg_crc=0xFFFF;
   while(length--){
       reg_crc ^= *data++;
       for(j=0;j<8;j++){
           if(reg_crc & 0x01){ /* LSB(b0)=1 */
              reg_crc=(reg_crc>>1) ^ 0xA001;
           }else{
              reg_crc=reg_crc >>1;
           }
       }
   }
   return reg_crc;
}

void sendCommand(uint16_t addr, uint16_t val)
{
   uint8_t data[8];
   unsigned int crc;
   //data[0] = 0x05;
		data[0] = 0x01;
   data[1] = 0x06;
   data[2] = addr / 256;
   data[3] = addr % 256;
   data[4] = val / 256;
   data[5] = val % 256;
   crc = crc_chk(data, 6);
   data[7] = crc / 256;
   data[6] = crc % 256;
    HAL_GPIO_WritePin(GPIOA, GPIO_PIN_1, GPIO_PIN_RESET);
		HAL_UART_Transmit(&hlpuart1,(uint8_t*)data,8,0xFFFF);
}
//ĴַдĴֵ
void sendCommand1(uint16_t addr, uint16_t val)
{
   uint8_t data[8];
   unsigned int crc;
   data[0] = 0x15;
   data[1] = 0x06;
   data[2] = addr / 256;
   data[3] = addr % 256;
   data[4] = val / 256;
   data[5] = val % 256;
   crc = crc_chk(data, 6);
   data[7] = crc / 256;
   data[6] = crc % 256;
    HAL_GPIO_WritePin(GPIOA, GPIO_PIN_1, GPIO_PIN_RESET);
		HAL_UART_Transmit(&hlpuart1,(uint8_t*)data,8,0xFFFF);
}

void startMotor()
{
		//sendCommand(0x000A,0x0001);
}
void stopMotor()
{
		//sendCommand(0x000A,0x0000);
}
void setMotorTurn()
{
		//sendCommand(0x000F,0x0001);
}
void setMotorSpeed(uint16_t speed)
{
		//sendCommand(0x000B,speed);
}
void stopMotor1()
{
		sendCommand1(0x0000,0x0000);
}

void setMotorTurn1()
{
		sendCommand1(0x000A,0x0001);
}

void setModel()
{
    sendCommand1(0x0008,0x0001);
}

void setMotorSpeed1(uint16_t speed)
{
		sendCommand1(0x0000,speed);
}


//#define  USE_HAL_UART_REGISTER_CALLBACKS 1

void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart)
{
	
	BaseType_t xHigherPriorityTaskWoken=pdFALSE;
	
	UNUSED(huart);
	if(huart->Instance == USART2){
		
		if(aRxBuffer[0] == 0xaa && aRxBuffer[1] == 0xaa && aRxBuffer[6] == 0x55 && aRxBuffer[7] == 0x55)
		{
					xMonitorMessage msg;
					msg.Device = 1;
					msg.Operation = aRxBuffer[2];


						msg.Value = aRxBuffer[3] + (aRxBuffer[4]*256);
				xQueueSendFromISR(xMonitorQueue,(void *) &msg, &xHigherPriorityTaskWoken );
					memset(aRxBuffer,0,sizeof(aRxBuffer));
				//	 xQueueSend(xMonitorQueue, (void *) &msg,  (TickType_t)10);

				//printf("dok\n");
					

					
		}
		
		//memset(aRxBuffer,0,sizeof(aRxBuffer));
		
	}
		
	//HAL_UART_Transmit(&huart2,(uint8_t*)aRxBuffer,10,0xFFFF);//(uint8_t*)aRxBuffer??????10??????0xFFFF?????
	//HAL_UART_Receive(&huart2,(uint8_t*)aRxtemp,1,0xffff);
}

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  *
  * @retval None
  */
int main(void)
{
  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration----------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_USART2_UART_Init();
  MX_LPUART1_UART_Init();

  /* Initialize interrupts */
  MX_NVIC_Init();
  /* USER CODE BEGIN 2 */
	
	__HAL_UART_ENABLE_IT(&huart2, UART_IT_RXNE);

	HAL_GPIO_WritePin(GPIOA, GPIO_PIN_1, GPIO_PIN_SET);
	//printf("Start OK!");
	
	
	xMonitorQueue  = xQueueCreate( MONITOR_QUEUE_SIZE, sizeof( xMonitorMessage ) );
	
	HAL_GPIO_WritePin(GPIOA, GPIO_PIN_1, GPIO_PIN_RESET);
	setMotorTurn();
	startMotor();
setModel();
//	stopMotor1();
//	setMotorTurn1();
//	osDelay(100);
//	setModel();
	//_ʼ
	//HAL_UART_Receive_IT(&huart2,(uint8_t*)aRxBuffer,8);
  /* USER CODE END 2 */

  /* USER CODE BEGIN RTOS_MUTEX */
  /* add mutexes, ... */
  /* USER CODE END RTOS_MUTEX */

  /* USER CODE BEGIN RTOS_SEMAPHORES */
  /* add semaphores, ... */
  /* USER CODE END RTOS_SEMAPHORES */

  /* USER CODE BEGIN RTOS_TIMERS */
  /* start timers, add new ones, ... */
  /* USER CODE END RTOS_TIMERS */

  /* Create the thread(s) */
  /* definition and creation of defaultTask */
  osThreadDef(defaultTask, StartDefaultTask, osPriorityNormal, 0, 128);
  defaultTaskHandle = osThreadCreate(osThread(defaultTask), NULL);

  /* definition and creation of myTaskUART1 */
  osThreadDef(myTaskUART1, StartTaskUART1, osPriorityIdle, 0, 128);
  myTaskUART1Handle = osThreadCreate(osThread(myTaskUART1), NULL);

  /* definition and creation of myTaskUART2 */
  osThreadDef(myTaskUART2, StartTaskUART2, osPriorityIdle, 0, 128);
  myTaskUART2Handle = osThreadCreate(osThread(myTaskUART2), NULL);

  /* USER CODE BEGIN RTOS_THREADS */
  /* add threads, ... */
  /* USER CODE END RTOS_THREADS */

  /* USER CODE BEGIN RTOS_QUEUES */
  /* add queues, ... */
  /* USER CODE END RTOS_QUEUES */
 

  /* Start scheduler */
  osKernelStart();
  
  /* We should never get here as control is now taken by the scheduler */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
		
		
		
		delay_ms(10);

  /* USER CODE END WHILE */

  /* USER CODE BEGIN 3 */

  }
  /* USER CODE END 3 */

}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{

  RCC_OscInitTypeDef RCC_OscInitStruct;
  RCC_ClkInitTypeDef RCC_ClkInitStruct;
  RCC_PeriphCLKInitTypeDef PeriphClkInit;

    /**Configure the main internal regulator output voltage 
    */
  __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);

    /**Configure LSE Drive Capability 
    */
  HAL_PWR_EnableBkUpAccess();

  __HAL_RCC_LSEDRIVE_CONFIG(RCC_LSEDRIVE_LOW);

    /**Initializes the CPU, AHB and APB busses clocks 
    */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI|RCC_OSCILLATORTYPE_LSE;
  RCC_OscInitStruct.LSEState = RCC_LSE_ON;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSICalibrationValue = 16;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_NONE;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    _Error_Handler(__FILE__, __LINE__);
  }

    /**Initializes the CPU, AHB and APB busses clocks 
    */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_HSI;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_0) != HAL_OK)
  {
    _Error_Handler(__FILE__, __LINE__);
  }

  PeriphClkInit.PeriphClockSelection = RCC_PERIPHCLK_USART2|RCC_PERIPHCLK_LPUART1;
  PeriphClkInit.Usart2ClockSelection = RCC_USART2CLKSOURCE_HSI;
  PeriphClkInit.Lpuart1ClockSelection = RCC_LPUART1CLKSOURCE_LSE;
  if (HAL_RCCEx_PeriphCLKConfig(&PeriphClkInit) != HAL_OK)
  {
    _Error_Handler(__FILE__, __LINE__);
  }

    /**Configure the Systick interrupt time 
    */
  HAL_SYSTICK_Config(HAL_RCC_GetHCLKFreq()/1000);

    /**Configure the Systick 
    */
  HAL_SYSTICK_CLKSourceConfig(SYSTICK_CLKSOURCE_HCLK);

  /* SysTick_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(SysTick_IRQn, 3, 0);
}

/**
  * @brief NVIC Configuration.
  * @retval None
  */
static void MX_NVIC_Init(void)
{
  /* AES_RNG_LPUART1_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(AES_RNG_LPUART1_IRQn, 3, 0);
  HAL_NVIC_EnableIRQ(AES_RNG_LPUART1_IRQn);
  /* USART2_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(USART2_IRQn, 3, 0);
  HAL_NVIC_EnableIRQ(USART2_IRQn);
}

/* LPUART1 init function */
static void MX_LPUART1_UART_Init(void)
{

  hlpuart1.Instance = LPUART1;
  hlpuart1.Init.BaudRate = 2400;//--2025.03.269600Ϊ2400
  hlpuart1.Init.WordLength = UART_WORDLENGTH_8B;
  hlpuart1.Init.StopBits = UART_STOPBITS_1;
  hlpuart1.Init.Parity = UART_PARITY_NONE;
  hlpuart1.Init.Mode = UART_MODE_TX_RX;
  hlpuart1.Init.HwFlowCtl = UART_HWCONTROL_NONE;
  hlpuart1.Init.OneBitSampling = UART_ONE_BIT_SAMPLE_ENABLE;
  hlpuart1.AdvancedInit.AdvFeatureInit = UART_ADVFEATURE_NO_INIT;
  if (HAL_UART_Init(&hlpuart1) != HAL_OK)
  {
    _Error_Handler(__FILE__, __LINE__);
  }

}

/* USART2 init function */
static void MX_USART2_UART_Init(void)
{

  huart2.Instance = USART2;
  huart2.Init.BaudRate = 2400;
  huart2.Init.WordLength = UART_WORDLENGTH_8B;
  huart2.Init.StopBits = UART_STOPBITS_1;
  huart2.Init.Parity = UART_PARITY_NONE;
  huart2.Init.Mode = UART_MODE_TX_RX;
  huart2.Init.HwFlowCtl = UART_HWCONTROL_NONE;
  huart2.Init.OverSampling = UART_OVERSAMPLING_16;
  huart2.Init.OneBitSampling = UART_ONE_BIT_SAMPLE_DISABLE;
  huart2.AdvancedInit.AdvFeatureInit = UART_ADVFEATURE_NO_INIT;
  if (HAL_UART_Init(&huart2) != HAL_OK)
  {
    _Error_Handler(__FILE__, __LINE__);
  }

}

/** Configure pins as 
        * Analog 
        * Input 
        * Output
        * EVENT_OUT
        * EXTI
*/
static void MX_GPIO_Init(void)
{

  GPIO_InitTypeDef GPIO_InitStruct;

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOC_CLK_ENABLE();
  __HAL_RCC_GPIOA_CLK_ENABLE();
  __HAL_RCC_GPIOB_CLK_ENABLE();

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOA, GPIO_PIN_1, GPIO_PIN_RESET);

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOB, GPIO_PIN_1, GPIO_PIN_RESET);

  /*Configure GPIO pin : PA1 */
  GPIO_InitStruct.Pin = GPIO_PIN_1;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /*Configure GPIO pin : PB1 */
  GPIO_InitStruct.Pin = GPIO_PIN_6;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/* USER CODE BEGIN Header_StartDefaultTask */
/**
  * @brief  Function implementing the defaultTask thread.
  * @param  argument: Not used 
  * @retval None
  */
/* USER CODE END Header_StartDefaultTask */
void StartDefaultTask(void const * argument)
{

  /* USER CODE BEGIN 5 */
  /* Infinite loop */
	osDelay(5000);
  for(;;)
  {
    HAL_GPIO_WritePin(GPIOB, GPIO_PIN_6, GPIO_PIN_RESET);
    osDelay(1000);
		HAL_GPIO_WritePin(GPIOB, GPIO_PIN_6, GPIO_PIN_SET);
		osDelay(1000);
		//setModel();
		//startMotor();
		
		//printf("Start OK!");
  }
  /* USER CODE END 5 */ 
}

/* USER CODE BEGIN Header_StartTaskUART1 */
/**
* @brief Function implementing the myTaskUART1 thread.
* @param argument: Not used
* @retval None
*/
/* USER CODE END Header_StartTaskUART1 */
void StartTaskUART1(void const * argument)
{
  /* USER CODE BEGIN StartTaskUART1 */
	BaseType_t xResult;
	const TickType_t xMaxBlockTime = pdMS_TO_TICKS(3000); /* ȴʱΪ300ms */
	uint8_t ucQueueMsgValue;
	xMonitorMessage msg;
	uint16_t speed = 0;
	
//	osDelay(2000);//--2025.03.26رָͣ
//	stopMotor1(); //--2025.03.26رָͣ
	osDelay(5000);
	setMotorTurn1();
	osDelay(200);
	
	setModel();//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	while(1)
	{
			xResult = xQueueReceive(xMonitorQueue,                   /* Ϣо */
															(void *)&msg,  /* 洢յݵucQueueMsgValue */
															(TickType_t)xMaxBlockTime);/* ʱ */
			
			if(xResult == pdPASS)
			{
					/* ɹգͨڽݴӡ */
					if(msg.Operation == 0x10) //ٶ
					{
							 if(msg.Value <= 5000)
							 {
								 setModel();
								 if(msg.Value == 0)
								 {
										//stopMotor();
									 osDelay(500);//--2025.03.26µ⼸ʱʱ100Ϊ500
									 stopMotor1();
									 osDelay(500);
									 speed = 0;
								  //setMotorSpeed(speed);
									 setMotorSpeed1(speed);
									 osDelay(500);
								 }
								 else{
									 //setMotorTurn1();
								 	//speed = 150 + msg.Value * 0.27 ;
									 speed = (msg.Value /100)*30;
									//speed = 1500 ;
									 //setMotorTurn();
								  //setMotorSpeed(speed);
									 osDelay(500);
									 setMotorSpeed1(speed);
									 osDelay(500);
									 //startMotor();
								 }

							 }
					}
					else if(msg.Operation == 2) //ٶ
					{
							 //startMotor();
					}
					else if(msg.Operation == 3) //ٶ
					{
							 //stopMotor();
							osDelay(500);
							stopMotor1();
					}
			}
			else
			{
					/* ʱ */
					
			}
	}
		
  /* USER CODE END StartTaskUART1 */
}

/* USER CODE BEGIN Header_StartTaskUART2 */
/**
* @brief Function implementing the myTaskUART2 thread.
* @param argument: Not used
* @retval None
*/
/* USER CODE END Header_StartTaskUART2 */
void StartTaskUART2(void const * argument)
{
  /* USER CODE BEGIN StartTaskUART2 */
  /* Infinite loop */
	HAL_UART_Receive_IT(&huart2,(uint8_t*)aRxBuffer,8);
  for(;;)
  {
			if(HAL_UART_GetState(&huart2) == HAL_UART_STATE_READY)
			{
					memset(aRxBuffer,0,sizeof(aRxBuffer));
					osDelay(10);
					HAL_UART_Receive_IT(&huart2,(uint8_t*)aRxBuffer,8);
					
//						xMonitorMessage msg;
//						msg.Device = 1;
//						msg.Operation = 2;
//						msg.Value = 10;
//					 xQueueSend(xMonitorQueue, (void *) &msg,  (TickType_t)10);
			}
			
		osDelay(30);    
  }
  /* USER CODE END StartTaskUART2 */
}

/**
  * @brief  This function is executed in case of error occurrence.
  * @param  file: The file name as string.
  * @param  line: The line in file as a number.
  * @retval None
  */
void _Error_Handler(char *file, int line)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  while(1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     tex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
