package com.dji.sdk.mqtt.ai;

import com.dji.sdk.mqtt.ChannelName;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.Message;

import java.io.IOException;

/**
 * @author guan
 */
public abstract class AbstractAiInfoService {

    /**
     * Handle the reply message from topic "/ai_info".
     * @param message   reply message
     * @throws IOException
     */
    @ServiceActivator(inputChannel = ChannelName.INBOUND_AI_INFO)
    public void aiInfo(Message<?> message) throws IOException {
        throw new UnsupportedOperationException("aiInfo not implemented");
    }

}
