package com.dji.sample.manage.service;

import com.dji.sample.manage.model.dto.FleetDTO;
import com.dji.sdk.common.PaginationData;

import java.util.List;

/**
 * @author guan
 */
public interface IFleetService {

    List<FleetDTO> getFleets(String workspaceId);

    PaginationData<FleetDTO> getFleetPage(String workspaceId, Long page, Long pageSize);

    FleetDTO getFleetBySn(String workspaceId, String fleetSn);

    boolean addFleet(FleetDTO fleetDTO);

    boolean editFleet(FleetDTO fleetDTO);

    boolean deleteFleet(String fleetSn);

    boolean deleteFleetById(String workspaceId, Integer id);

}
