package com.dji.sdk.cloudapi.control;

import com.dji.sdk.cloudapi.device.MeasureTargetStateEnum;

/**
 * 相机OSD信息推送
 * @author sean
 * @version 1.7
 * @date 2023/6/29
 */
public class CameraOsdInfoPush {

    private String payloadIndex;

    private Float gimbalPitch;

    private Float gimbalRoll;

    private Float gimbalYaw;

    private WideLense wideLense;

    private ZoomLense zoomLense;

    private MeasureTarget measureTarget;

    private IrLense irLense;

    private Liveview liveview;

    public CameraOsdInfoPush() {
    }

    @Override
    public String toString() {
        return "CameraOsdInfoPush{" +
                "payloadIndex='" + payloadIndex + '\'' +
                ", gimbalPitch=" + gimbalPitch +
                ", gimbalRoll=" + gimbalRoll +
                ", gimbalYaw=" + gimbalYaw +
                ", wideLense=" + wideLense +
                ", zoomLense=" + zoomLense +
                ", measureTarget=" + measureTarget +
                ", irLense=" + irLense +
                ", liveview=" + liveview +
                '}';
    }

    // Getters and Setters
    public String getPayloadIndex() {
        return payloadIndex;
    }

    public CameraOsdInfoPush setPayloadIndex(String payloadIndex) {
        this.payloadIndex = payloadIndex;
        return this;
    }

    public Float getGimbalPitch() {
        return gimbalPitch;
    }

    public CameraOsdInfoPush setGimbalPitch(Float gimbalPitch) {
        this.gimbalPitch = gimbalPitch;
        return this;
    }

    public Float getGimbalRoll() {
        return gimbalRoll;
    }

    public CameraOsdInfoPush setGimbalRoll(Float gimbalRoll) {
        this.gimbalRoll = gimbalRoll;
        return this;
    }

    public Float getGimbalYaw() {
        return gimbalYaw;
    }

    public CameraOsdInfoPush setGimbalYaw(Float gimbalYaw) {
        this.gimbalYaw = gimbalYaw;
        return this;
    }

    public WideLense getWideLense() {
        return wideLense;
    }

    public CameraOsdInfoPush setWideLense(WideLense wideLense) {
        this.wideLense = wideLense;
        return this;
    }

    public ZoomLense getZoomLense() {
        return zoomLense;
    }

    public CameraOsdInfoPush setZoomLense(ZoomLense zoomLense) {
        this.zoomLense = zoomLense;
        return this;
    }

    public MeasureTarget getMeasureTarget() {
        return measureTarget;
    }

    public CameraOsdInfoPush setMeasureTarget(MeasureTarget measureTarget) {
        this.measureTarget = measureTarget;
        return this;
    }

    public IrLense getIrLense() {
        return irLense;
    }

    public CameraOsdInfoPush setIrLense(IrLense irLense) {
        this.irLense = irLense;
        return this;
    }

    public Liveview getLiveview() {
        return liveview;
    }

    public CameraOsdInfoPush setLiveview(Liveview liveview) {
        this.liveview = liveview;
        return this;
    }

    /**
     * 广角镜头信息
     */
    public static class WideLense {
        private Integer wideExposureMode;
        private Integer wideIso;
        private Integer wideShutterSpeed;
        private Integer wideExposureValue;
        private Integer wideApertureValue;

        // Getters and Setters
        public Integer getWideExposureMode() {
            return wideExposureMode;
        }

        public WideLense setWideExposureMode(Integer wideExposureMode) {
            this.wideExposureMode = wideExposureMode;
            return this;
        }

        public Integer getWideIso() {
            return wideIso;
        }

        public WideLense setWideIso(Integer wideIso) {
            this.wideIso = wideIso;
            return this;
        }

        public Integer getWideShutterSpeed() {
            return wideShutterSpeed;
        }

        public WideLense setWideShutterSpeed(Integer wideShutterSpeed) {
            this.wideShutterSpeed = wideShutterSpeed;
            return this;
        }

        public Integer getWideExposureValue() {
            return wideExposureValue;
        }

        public WideLense setWideExposureValue(Integer wideExposureValue) {
            this.wideExposureValue = wideExposureValue;
            return this;
        }

        public Integer getWideApertureValue() {
            return wideApertureValue;
        }

        public WideLense setWideApertureValue(Integer wideApertureValue) {
            this.wideApertureValue = wideApertureValue;
            return this;
        }
    }

    /**
     * 变焦镜头信息
     */
    public static class ZoomLense {
        private Integer zoomExposureMode;
        private Integer zoomIso;
        private Integer zoomShutterSpeed;
        private Integer zoomExposureValue;
        private Integer zoomFocusMode;
        private Integer zoomFocusValue;
        private Integer zoomMaxFocusValue;
        private Integer zoomMinFocusValue;
        private Integer zoomCalibrateFarthestFocusValue;
        private Integer zoomCalibrateNearestFocusValue;
        private Integer zoomFocusState;
        private Float zoomFactor;
        private Integer zoomApertureValue;

        // Getters and Setters (省略，与WideLense类似)
        public Integer getZoomExposureMode() {
            return zoomExposureMode;
        }

        public ZoomLense setZoomExposureMode(Integer zoomExposureMode) {
            this.zoomExposureMode = zoomExposureMode;
            return this;
        }

        public Integer getZoomIso() {
            return zoomIso;
        }

        public ZoomLense setZoomIso(Integer zoomIso) {
            this.zoomIso = zoomIso;
            return this;
        }

        public Integer getZoomShutterSpeed() {
            return zoomShutterSpeed;
        }

        public ZoomLense setZoomShutterSpeed(Integer zoomShutterSpeed) {
            this.zoomShutterSpeed = zoomShutterSpeed;
            return this;
        }

        public Integer getZoomExposureValue() {
            return zoomExposureValue;
        }

        public ZoomLense setZoomExposureValue(Integer zoomExposureValue) {
            this.zoomExposureValue = zoomExposureValue;
            return this;
        }

        public Integer getZoomFocusMode() {
            return zoomFocusMode;
        }

        public ZoomLense setZoomFocusMode(Integer zoomFocusMode) {
            this.zoomFocusMode = zoomFocusMode;
            return this;
        }

        public Integer getZoomFocusValue() {
            return zoomFocusValue;
        }

        public ZoomLense setZoomFocusValue(Integer zoomFocusValue) {
            this.zoomFocusValue = zoomFocusValue;
            return this;
        }

        public Integer getZoomMaxFocusValue() {
            return zoomMaxFocusValue;
        }

        public ZoomLense setZoomMaxFocusValue(Integer zoomMaxFocusValue) {
            this.zoomMaxFocusValue = zoomMaxFocusValue;
            return this;
        }

        public Integer getZoomMinFocusValue() {
            return zoomMinFocusValue;
        }

        public ZoomLense setZoomMinFocusValue(Integer zoomMinFocusValue) {
            this.zoomMinFocusValue = zoomMinFocusValue;
            return this;
        }

        public Integer getZoomCalibrateFarthestFocusValue() {
            return zoomCalibrateFarthestFocusValue;
        }

        public ZoomLense setZoomCalibrateFarthestFocusValue(Integer zoomCalibrateFarthestFocusValue) {
            this.zoomCalibrateFarthestFocusValue = zoomCalibrateFarthestFocusValue;
            return this;
        }

        public Integer getZoomCalibrateNearestFocusValue() {
            return zoomCalibrateNearestFocusValue;
        }

        public ZoomLense setZoomCalibrateNearestFocusValue(Integer zoomCalibrateNearestFocusValue) {
            this.zoomCalibrateNearestFocusValue = zoomCalibrateNearestFocusValue;
            return this;
        }

        public Integer getZoomFocusState() {
            return zoomFocusState;
        }

        public ZoomLense setZoomFocusState(Integer zoomFocusState) {
            this.zoomFocusState = zoomFocusState;
            return this;
        }

        public Float getZoomFactor() {
            return zoomFactor;
        }

        public ZoomLense setZoomFactor(Float zoomFactor) {
            this.zoomFactor = zoomFactor;
            return this;
        }

        public Integer getZoomApertureValue() {
            return zoomApertureValue;
        }

        public ZoomLense setZoomApertureValue(Integer zoomApertureValue) {
            this.zoomApertureValue = zoomApertureValue;
            return this;
        }
    }

    /**
     * 目标测距和测高
     */
    public static class MeasureTarget {
        private Double measureTargetLongitude;
        private Double measureTargetLatitude;
        private Double measureTargetAltitude;
        private Double measureTargetDistance;
        private MeasureTargetStateEnum measureTargetErrorState;

        public MeasureTarget() {
        }

        @Override
        public String toString() {
            return "MeasureTarget{" +
                    "measureTargetLongitude=" + measureTargetLongitude +
                    ", measureTargetLatitude=" + measureTargetLatitude +
                    ", measureTargetAltitude=" + measureTargetAltitude +
                    ", measureTargetDistance=" + measureTargetDistance +
                    ", measureTargetErrorState=" + measureTargetErrorState +
                    '}';
        }

        public Double getMeasureTargetLongitude() {
            return measureTargetLongitude;
        }

        public MeasureTarget setMeasureTargetLongitude(Double measureTargetLongitude) {
            this.measureTargetLongitude = measureTargetLongitude;
            return this;
        }

        public Double getMeasureTargetLatitude() {
            return measureTargetLatitude;
        }

        public MeasureTarget setMeasureTargetLatitude(Double measureTargetLatitude) {
            this.measureTargetLatitude = measureTargetLatitude;
            return this;
        }

        public Double getMeasureTargetAltitude() {
            return measureTargetAltitude;
        }

        public MeasureTarget setMeasureTargetAltitude(Double measureTargetAltitude) {
            this.measureTargetAltitude = measureTargetAltitude;
            return this;
        }

        public Double getMeasureTargetDistance() {
            return measureTargetDistance;
        }

        public MeasureTarget setMeasureTargetDistance(Double measureTargetDistance) {
            this.measureTargetDistance = measureTargetDistance;
            return this;
        }

        public MeasureTargetStateEnum getMeasureTargetErrorState() {
            return measureTargetErrorState;
        }

        public MeasureTarget setMeasureTargetErrorState(MeasureTargetStateEnum measureTargetErrorState) {
            this.measureTargetErrorState = measureTargetErrorState;
            return this;
        }
    }

    /**
     * 红外信息
     */
    public static class IrLense {
        private Boolean screenSplitEnable;
        private Float irZoomFactor;
        private Integer thermalCurrentPaletteStyle;
        private Integer thermalGainMode;
        private Integer thermalIsothermState;
        private Integer thermalIsothermUpperLimit;
        private Integer thermalIsothermLowerLimit;
        private Float thermalGlobalTemperatureMin;
        private Float thermalGlobalTemperatureMax;

        public IrLense() {
        }

        public Boolean getScreenSplitEnable() {
            return screenSplitEnable;
        }

        public IrLense setScreenSplitEnable(Boolean screenSplitEnable) {
            this.screenSplitEnable = screenSplitEnable;
            return this;
        }

        public Float getIrZoomFactor() {
            return irZoomFactor;
        }

        public IrLense setIrZoomFactor(Float irZoomFactor) {
            this.irZoomFactor = irZoomFactor;
            return this;
        }

        public Integer getThermalCurrentPaletteStyle() {
            return thermalCurrentPaletteStyle;
        }

        public IrLense setThermalCurrentPaletteStyle(Integer thermalCurrentPaletteStyle) {
            this.thermalCurrentPaletteStyle = thermalCurrentPaletteStyle;
            return this;
        }

        public Integer getThermalGainMode() {
            return thermalGainMode;
        }

        public IrLense setThermalGainMode(Integer thermalGainMode) {
            this.thermalGainMode = thermalGainMode;
            return this;
        }

        public Integer getThermalIsothermState() {
            return thermalIsothermState;
        }

        public IrLense setThermalIsothermState(Integer thermalIsothermState) {
            this.thermalIsothermState = thermalIsothermState;
            return this;
        }

        public Integer getThermalIsothermUpperLimit() {
            return thermalIsothermUpperLimit;
        }

        public IrLense setThermalIsothermUpperLimit(Integer thermalIsothermUpperLimit) {
            this.thermalIsothermUpperLimit = thermalIsothermUpperLimit;
            return this;
        }

        public Integer getThermalIsothermLowerLimit() {
            return thermalIsothermLowerLimit;
        }

        public IrLense setThermalIsothermLowerLimit(Integer thermalIsothermLowerLimit) {
            this.thermalIsothermLowerLimit = thermalIsothermLowerLimit;
            return this;
        }

        public Float getThermalGlobalTemperatureMin() {
            return thermalGlobalTemperatureMin;
        }

        public IrLense setThermalGlobalTemperatureMin(Float thermalGlobalTemperatureMin) {
            this.thermalGlobalTemperatureMin = thermalGlobalTemperatureMin;
            return this;
        }

        public Float getThermalGlobalTemperatureMax() {
            return thermalGlobalTemperatureMax;
        }

        public IrLense setThermalGlobalTemperatureMax(Float thermalGlobalTemperatureMax) {
            this.thermalGlobalTemperatureMax = thermalGlobalTemperatureMax;
            return this;
        }
    }

    /**
     * 直播视图区域信息
     */
    public static class Liveview {
        private LiveviewWorldRegion liveviewWorldRegion;

        public LiveviewWorldRegion getLiveviewWorldRegion() {
            return liveviewWorldRegion;
        }

        public Liveview setLiveviewWorldRegion(LiveviewWorldRegion liveviewWorldRegion) {
            this.liveviewWorldRegion = liveviewWorldRegion;
            return this;
        }

        public static class LiveviewWorldRegion {
            private Float left;
            private Float top;
            private Float right;
            private Float bottom;

            public Float getLeft() {
                return left;
            }

            public LiveviewWorldRegion setLeft(Float left) {
                this.left = left;
                return this;
            }

            public Float getTop() {
                return top;
            }

            public LiveviewWorldRegion setTop(Float top) {
                this.top = top;
                return this;
            }

            public Float getRight() {
                return right;
            }

            public LiveviewWorldRegion setRight(Float right) {
                this.right = right;
                return this;
            }

            public Float getBottom() {
                return bottom;
            }

            public LiveviewWorldRegion setBottom(Float bottom) {
                this.bottom = bottom;
                return this;
            }
        }
    }
}
