package com.dji.sample.manage.model.receiver;

import com.dji.sdk.cloudapi.control.CommanderModeLostActionEnum;
import com.dji.sdk.cloudapi.device.OsdDockDrone;
import com.dji.sdk.cloudapi.device.RcLostActionEnum;
import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.Objects;

/**
 * @author sean
 * @version 1.4
 * @date 2023/3/3
 */
public class CommanderModeLostActionReceiver extends BasicDeviceProperty {

    private CommanderModeLostActionEnum commanderModeLostAction;

    @JsonCreator
    public CommanderModeLostActionReceiver(Integer commanderModeLostAction) {
        this.commanderModeLostAction = CommanderModeLostActionEnum.find(commanderModeLostAction);
    }

    @Override
    public boolean valid() {
        return Objects.nonNull(commanderModeLostAction);
    }

    @Override
    public boolean canPublish(OsdDockDrone osd) {
        return commanderModeLostAction != osd.getCommanderModeLostAction();
    }
}
