package com.dji.sdk.cloudapi.wayline;

import com.dji.sdk.annotations.CloudSDKVersion;
import com.dji.sdk.cloudapi.device.ExitWaylineWhenRcLostEnum;
import com.dji.sdk.common.BaseModel;
import com.dji.sdk.config.version.CloudSDKVersionEnum;
import com.dji.sdk.config.version.GatewayTypeEnum;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @author sean
 * @version 1.7
 * @date 2023/6/6
 */
public class InFlightWaylineTaskPrepareRequest extends BaseModel {

    /**
     * 航线任务ID
     */
    @NotNull
    @Pattern(regexp = "^[^<>:\"/|?*._\\\\]+$")
    private String inFlightWaylineId;

    /**
     * 返航高度 {min: 20, max: 1500}
     */
    @NotNull
    @Min(20)
    @Max(1500)
    private Integer rthAltitude;

    /**
     * 遥控器失控时的动作 {0: "返航", 1: "悬停", 2: "降落"}
     */
    @NotNull
    private OutOfControlActionEnum outOfControlAction;

    /**
     * 航线失联时的动作 {0: "继续执行", 1: "执行飞控失控动作"}
     */
    @NotNull
    private ExitWaylineWhenRcLostEnum exitWaylineWhenRcLost;

    /**
     * 返航高度模式 {0: "智能高度", 1: "设定高度"}
     */
    @CloudSDKVersion(since = CloudSDKVersionEnum.V1_0_0)
    private RthModeEnum rthMode = RthModeEnum.PRESET_HEIGHT;

    /**
     * 航线精度类型 {0: "GPS任务", 1: "高精度RTK任务"}
     */
    @NotNull
    @CloudSDKVersion(since = CloudSDKVersionEnum.V1_0_1, include = {GatewayTypeEnum.DOCK2, GatewayTypeEnum.DOCK3})
    private WaylinePrecisionTypeEnum waylinePrecisionType;

    /**
     * 航线文件信息
     */
    @NotNull
    @Valid
    private FlighttaskFile file;

    /**
     * 草莓自定义流程
     */
    private CustomProcess customProcess;

    public InFlightWaylineTaskPrepareRequest() {}

    @Override
    public String toString() {
        return "FlighttaskPrepareRequest{" +
                "inFlightWaylineId='" + inFlightWaylineId + '\'' +
                ", file=" + file +
                ", rthAltitude=" + rthAltitude +
                ", outOfControlAction=" + outOfControlAction +
                ", exitWaylineWhenRcLost=" + exitWaylineWhenRcLost +
                ", rthMode=" + rthMode +
                ", waylinePrecisionType=" + waylinePrecisionType +
                ", customProcess=" + customProcess +
                '}';
    }

    public String getInFlightWaylineId() {
        return inFlightWaylineId;
    }

    public InFlightWaylineTaskPrepareRequest setInFlightWaylineId(String inFlightWaylineId) {
        this.inFlightWaylineId = inFlightWaylineId;
        return this;
    }

    public FlighttaskFile getFile() {
        return file;
    }

    public InFlightWaylineTaskPrepareRequest setFile(FlighttaskFile file) {
        this.file = file;
        return this;
    }

    public Integer getRthAltitude() {
        return rthAltitude;
    }

    public InFlightWaylineTaskPrepareRequest setRthAltitude(Integer rthAltitude) {
        this.rthAltitude = rthAltitude;
        return this;
    }

    public OutOfControlActionEnum getOutOfControlAction() {
        return outOfControlAction;
    }

    public InFlightWaylineTaskPrepareRequest setOutOfControlAction(OutOfControlActionEnum outOfControlAction) {
        this.outOfControlAction = outOfControlAction;
        return this;
    }

    public ExitWaylineWhenRcLostEnum getExitWaylineWhenRcLost() {
        return exitWaylineWhenRcLost;
    }

    public InFlightWaylineTaskPrepareRequest setExitWaylineWhenRcLost(ExitWaylineWhenRcLostEnum exitWaylineWhenRcLost) {
        this.exitWaylineWhenRcLost = exitWaylineWhenRcLost;
        return this;
    }

    public RthModeEnum getRthMode() {
        return rthMode;
    }

    public InFlightWaylineTaskPrepareRequest setRthMode(RthModeEnum rthMode) {
        this.rthMode = rthMode;
        return this;
    }

    public CustomProcess getCustomProcess() {
        return customProcess;
    }

    public InFlightWaylineTaskPrepareRequest setCustomProcess(CustomProcess customProcess) {
        this.customProcess = customProcess;
        return this;
    }

    public WaylinePrecisionTypeEnum getWaylinePrecisionType() {
        return waylinePrecisionType;
    }

    public InFlightWaylineTaskPrepareRequest setWaylinePrecisionType(WaylinePrecisionTypeEnum waylinePrecisionType) {
        this.waylinePrecisionType = waylinePrecisionType;
        return this;
    }
}