package com.dji.sdk.config.version;

import com.dji.sdk.exception.CloudSDKVersionException;
import com.fasterxml.jackson.annotation.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author sean
 * @version 1.7
 * @date 2023/5/19
 */
public enum DroneThingVersionEnum implements IThingVersion {

    V1_0_0("1.0.0", CloudSDKVersionEnum.V0_0_1),

    V1_1_0("1.1.0", CloudSDKVersionEnum.V1_0_0),

    V1_1_2("1.1.2", CloudSDKVersionEnum.V1_0_0),

    V1_1_3("1.1.3", CloudSDKVersionEnum.V1_0_2),
    V1_1_4("1.1.4", CloudSDKVersionEnum.V1_0_2),
    V1_1_5("1.1.5", CloudSDKVersionEnum.V1_0_2),
    V1_1_6("1.1.6", CloudSDKVersionEnum.V1_0_2),
    V1_1_7("1.1.7", CloudSDKVersionEnum.V1_0_2),
    V1_1_8("1.1.8", CloudSDKVersionEnum.V1_0_2),
    V1_1_9("1.1.9", CloudSDKVersionEnum.V1_0_2),

    V1_2_0("1.2.0", CloudSDKVersionEnum.V1_0_3),
    V1_2_1("1.2.1", CloudSDKVersionEnum.V1_0_3),
    V1_2_2("1.2.2", CloudSDKVersionEnum.V1_0_3),
    V1_2_4("1.2.4", CloudSDKVersionEnum.V1_0_3),
    V1_2_5("1.2.5", CloudSDKVersionEnum.V1_0_3),
    // 升级dock3系统适配
    V1_2_6("1.2.6", CloudSDKVersionEnum.V1_0_3),
    V1_2_7("1.2.7", CloudSDKVersionEnum.V1_0_3),
    V1_2_8("1.2.8", CloudSDKVersionEnum.V1_0_3),
    V1_2_9("1.2.9", CloudSDKVersionEnum.V1_0_3),

    // v1_3_0("1.3.0", CloudSDKVersionEnum.V1_3_0),
    v1_3_0("1.3.0", CloudSDKVersionEnum.V1_0_3),

    V1_3_1("1.3.1", CloudSDKVersionEnum.V1_0_3),
    V1_3_2("1.3.2", CloudSDKVersionEnum.V1_0_3),
    V1_3_3("1.3.3", CloudSDKVersionEnum.V1_0_3),
    V1_3_4("1.3.4", CloudSDKVersionEnum.V1_0_3),
    V1_3_5("1.3.5", CloudSDKVersionEnum.V1_0_3),
    V1_3_6("1.3.6", CloudSDKVersionEnum.V1_0_3),
    V1_3_7("1.3.7", CloudSDKVersionEnum.V1_0_3),
    V1_3_8("1.3.8", CloudSDKVersionEnum.V1_0_3),
    V1_3_9("1.3.9", CloudSDKVersionEnum.V1_0_3),
    V1_4_0("1.4.0", CloudSDKVersionEnum.V1_0_3),

    /**
     * 草莓适配
     */
    v2_1_2("2.1.2", CloudSDKVersionEnum.V1_0_3),

    /**
     * dock3适配
     */
    V1_2_3("1.2.3", CloudSDKVersionEnum.V1_0_3),
    ;

    private static final Logger log = LoggerFactory.getLogger(DroneThingVersionEnum.class);

    private final String thingVersion;

    private final CloudSDKVersionEnum cloudSDKVersion;

    DroneThingVersionEnum(String thingVersion, CloudSDKVersionEnum cloudSDKVersion) {
        this.thingVersion = thingVersion;
        this.cloudSDKVersion = cloudSDKVersion;
    }

    @JsonValue
    public String getThingVersion() {
        return thingVersion;
    }

    public CloudSDKVersionEnum getCloudSDKVersion() {
        return cloudSDKVersion;
    }

    public static DroneThingVersionEnum find(String thingVersion) {
        Optional<DroneThingVersionEnum> opt = Arrays.stream(values())
                .filter(thingVersionEnum -> thingVersionEnum.thingVersion.equals(thingVersion)).findAny();
        if (opt.isPresent()) {
            return opt.get();
        }
        throw new CloudSDKVersionException(thingVersion);
    }
}
