package com.dji.sample.common.util;

import org.springframework.util.StringUtils;

import static com.dji.sample.common.constant.DeviceConstant.CUSTOM_DOCK_LIST;
import static com.dji.sample.common.constant.DeviceConstant.CUSTOM_DOCK_START;

/**
 * 设备常用工具类
 * @author guan
 */
public class DeviceUtil {

    /**
     * 是否智测系列设备
     * @param dockSn
     * @return
     */
    public static boolean isCustomDevice(String dockSn) {
        if (!StringUtils.hasText(dockSn)) {
            return false;
        }

        if (dockSn.startsWith(CUSTOM_DOCK_START)) {
            return true;
        }
        if (CUSTOM_DOCK_LIST.contains(dockSn) || dockSn.contains("12345")) {
            return true;
        }
        return false;
    }

}
