package com.dji.sample.media.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Folder tree structure for OSS browser.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class FolderTreeDTO {

    /**
     * Unique key for the folder (used as tree node key)
     */
    private String key;

    /**
     * Display title (folder name)
     */
    private String title;

    /**
     * Full path of the folder
     */
    private String path;

    /**
     * Whether this folder has children (for lazy loading)
     */
    private Boolean isLeaf;

    /**
     * Children folders (null for lazy loading)
     */
    private List<FolderTreeDTO> children;
}
