package com.dji.sdk.cloudapi.livestream;

import com.dji.sdk.cloudapi.device.VideoId;
import com.dji.sdk.common.BaseModel;

import javax.validation.constraints.NotNull;

/**
 * @author sean
 * @version 1.7
 * @date 2023/5/23
 */
public class LiveCameraChangeRequest extends BaseModel {

    @NotNull
    private CameraPositionEnum cameraPosition;

    /**
     * The format is #{uav_sn}/#{camera_id}/#{video_index},
     * drone serial number/payload and mounted location enumeration value/payload lens numbering
     */
    @NotNull
    private VideoId videoId;

    public LiveCameraChangeRequest() {
    }

    @Override
    public String toString() {
        return "LiveLensChangeRequest{" +
                "cameraPosition=" + cameraPosition +
                ", videoId=" + videoId +
                '}';
    }

    public CameraPositionEnum getCameraPosition() {
        return cameraPosition;
    }

    public LiveCameraChangeRequest setCameraPosition(CameraPositionEnum cameraPosition) {
        this.cameraPosition = cameraPosition;
        return this;
    }

    public VideoId getVideoId() {
        return videoId;
    }

    public LiveCameraChangeRequest setVideoId(VideoId videoId) {
        this.videoId = videoId;
        return this;
    }
}
