package com.dji.sdk.cloudapi.livestream;

import com.dji.sdk.exception.CloudSDKException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Arrays;

/**
 * @author sean
 * @version 1.7
 * @date 2023/6/25
 */
public enum CameraPositionEnum {

    INSIDE(0),

    OUTSIDE(1);

    private final int type;

    CameraPositionEnum(int type) {
        this.type = type;
    }

    @JsonValue
    public int getType() {
        return type;
    }

    @JsonCreator
    public static CameraPositionEnum find(int videoType) {
        return Arrays.stream(values()).filter(typeEnum -> typeEnum.type == videoType).findAny()
                .orElseThrow(() -> new CloudSDKException(CameraPositionEnum.class , videoType));
    }
}
