package com.dji.sdk.cloudapi.livestream;

import java.util.List;

/**
 * @author sean
 * @version 1.7
 * @date 2023/5/23
 */
public class DockLiveCapacity {

    /**
     * Total number of video streams available for livestreaming.
     * Indicates the total number of all available live video streams owned by the aircraft or device.
     */
    private Integer availableVideoNumber;

    /**
     * Maximum total number of video streams that can be lived stream simultaneously.
     */
    private Integer coexistVideoNumberMax;

    /**
     * Device live streaming capability list
     */
    private List<DockLiveCapacityDevice> deviceList;

    public DockLiveCapacity() {
    }

    @Override
    public String toString() {
        return "DockLiveCapacity{" +
                "availableVideoNumber=" + availableVideoNumber +
                ", coexistVideoNumberMax=" + coexistVideoNumberMax +
                ", deviceList=" + deviceList +
                '}';
    }

    public Integer getAvailableVideoNumber() {
        return availableVideoNumber;
    }

    public DockLiveCapacity setAvailableVideoNumber(Integer availableVideoNumber) {
        this.availableVideoNumber = availableVideoNumber;
        return this;
    }

    public Integer getCoexistVideoNumberMax() {
        return coexistVideoNumberMax;
    }

    public DockLiveCapacity setCoexistVideoNumberMax(Integer coexistVideoNumberMax) {
        this.coexistVideoNumberMax = coexistVideoNumberMax;
        return this;
    }

    public List<DockLiveCapacityDevice> getDeviceList() {
        return deviceList;
    }

    public DockLiveCapacity setDeviceList(List<DockLiveCapacityDevice> deviceList) {
        this.deviceList = deviceList;
        return this;
    }
}
