package com.dji.sample.manage.model.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author guan
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OrgDTO implements Serializable {
    private Integer id;
    private String orgId;
    private String orgName;
    private String orgDesc;
    private String workspaceId;

    private LocalDateTime createTime;
    private LocalDateTime updateTime;

    private String bindCode;

    @JsonProperty("admin_user_id")
    private String adminUserId;
    @JsonProperty("admin_user_name")
    private String adminUserName;
    @JsonProperty("admin_user_password")
    private String adminUserPassword;

}

