package com.dji.sdk.cloudapi.control;

import com.dji.sdk.cloudapi.device.PayloadIndex;
import com.dji.sdk.common.BaseModel;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author guan
 */
public class CameraScreenDragRequest extends BaseModel {

    @NotNull
    private PayloadIndex payloadIndex;

    /**
     * true: Lock the gimbal, the gimbal and the drone rotate together.
     * false: Only the gimbal rotates, but the drone does not.
     */
    @NotNull
    private Boolean locked;

    /**
     *{ "unit_name":"度每秒 / degree/s"}	云台 pitch 速度
     */
    // @Min(0)
    //@Max(1)
    private Double pitchSpeed;

    /**
     * {"unit_name":"度每秒 / degree/s"}	云台 yaw 速度，仅不锁机头时才生效
     */
    // @Min(0)
    //@Max(1)
    private Double yawSpeed;

    public CameraScreenDragRequest() {
    }

    @Override
    public String toString() {
        return "CameraAimRequest{" +
                "payloadIndex=" + payloadIndex +
                ", locked=" + locked +
                ", pitchSpeed=" + pitchSpeed +
                ", yawSpeed=" + yawSpeed +
                '}';
    }

    public PayloadIndex getPayloadIndex() {
        return payloadIndex;
    }

    public CameraScreenDragRequest setPayloadIndex(PayloadIndex payloadIndex) {
        this.payloadIndex = payloadIndex;
        return this;
    }

    public Boolean getLocked() {
        return locked;
    }

    public CameraScreenDragRequest setLocked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    public Double getPitchSpeed() {
        return pitchSpeed;
    }

    public CameraScreenDragRequest setPitchspeed(Double pitchSpeed) {
        this.pitchSpeed = pitchSpeed;
        return this;
    }

    public Double getYawSpeed() {
        return yawSpeed;
    }

    public CameraScreenDragRequest setYawSpeed(Double yawSpeed) {
        this.yawSpeed = yawSpeed;
        return this;
    }

}
