package com.dji.sample.manage.model.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author guan
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class FleetDeviceDTO implements Serializable {

    private Integer id;

    @JsonProperty("fleet_id")
    private String fleetId;

    @JsonProperty("device_id")
    private String deviceId;

    /**
     * 设备型号
     */
    @JsonProperty("device_enum_name")
    private String deviceEnumName;

    /**
     * 设备昵称
     */
    @JsonProperty("device_nickname")
    private String deviceNickname;

    @JsonProperty("device_enum")
    private String deviceEnum;

    private Integer domain;

    @JsonProperty("device_type")
    private Integer deviceType;

    @JsonProperty("sub_type")
    private Integer subType;

    @JsonProperty("device_sn")
    private String deviceSn;

}
