package com.dji.sdk.cloudapi.control;

import com.dji.sdk.cloudapi.device.MeasureTargetStateEnum;

/**
 * @author sean
 * @version 1.7
 * @date 2023/6/29
 */
public class OsdInfoPush {

    private Float attitudeHead;

    private Float latitude;

    private Float longitude;

    private Float height;

    private Float speedX;

    private Float speedY;

    private Float speedZ;

    private Float gimbalPitch;

    private Float gimbalRoll;

    private Float gimbalYaw;

    private MeasureTarget measureTarget;

    public OsdInfoPush() {
    }

    @Override
    public String toString() {
        return "OsdInfoPush{" +
                "attitudeHead=" + attitudeHead +
                ", latitude=" + latitude +
                ", longitude=" + longitude +
                ", height=" + height +
                ", speedX=" + speedX +
                ", speedY=" + speedY +
                ", speedZ=" + speedZ +
                ", gimbalPitch=" + gimbalPitch +
                ", gimbalRoll=" + gimbalRoll +
                ", gimbalYaw=" + gimbalYaw +
                ", measureTarget=" + measureTarget +
                '}';
    }

    public Float getAttitudeHead() {
        return attitudeHead;
    }

    public OsdInfoPush setAttitudeHead(Float attitudeHead) {
        this.attitudeHead = attitudeHead;
        return this;
    }

    public Float getLatitude() {
        return latitude;
    }

    public OsdInfoPush setLatitude(Float latitude) {
        this.latitude = latitude;
        return this;
    }

    public Float getLongitude() {
        return longitude;
    }

    public OsdInfoPush setLongitude(Float longitude) {
        this.longitude = longitude;
        return this;
    }

    public Float getHeight() {
        return height;
    }

    public OsdInfoPush setHeight(Float height) {
        this.height = height;
        return this;
    }

    public Float getSpeedX() {
        return speedX;
    }

    public OsdInfoPush setSpeedX(Float speedX) {
        this.speedX = speedX;
        return this;
    }

    public Float getSpeedY() {
        return speedY;
    }

    public OsdInfoPush setSpeedY(Float speedY) {
        this.speedY = speedY;
        return this;
    }

    public Float getSpeedZ() {
        return speedZ;
    }

    public OsdInfoPush setSpeedZ(Float speedZ) {
        this.speedZ = speedZ;
        return this;
    }

    public Float getGimbalPitch() {
        return gimbalPitch;
    }

    public OsdInfoPush setGimbalPitch(Float gimbalPitch) {
        this.gimbalPitch = gimbalPitch;
        return this;
    }

    public Float getGimbalRoll() {
        return gimbalRoll;
    }

    public OsdInfoPush setGimbalRoll(Float gimbalRoll) {
        this.gimbalRoll = gimbalRoll;
        return this;
    }

    public Float getGimbalYaw() {
        return gimbalYaw;
    }

    public OsdInfoPush setGimbalYaw(Float gimbalYaw) {
        this.gimbalYaw = gimbalYaw;
        return this;
    }

    public MeasureTarget getMeasureTarget() {
        return measureTarget;
    }

    public OsdInfoPush setMeasureTarget(MeasureTarget measureTarget) {
        this.measureTarget = measureTarget;
        return this;
    }

    /**
     * 目标测距和测高
     */
    public static class MeasureTarget {
        private Double measureTargetLongitude;
        private Double measureTargetLatitude;
        private Double measureTargetAltitude;
        private Double measureTargetDistance;
        private MeasureTargetStateEnum measureTargetErrorState;

        public MeasureTarget() {
        }

        @Override
        public String toString() {
            return "MeasureTarget{" +
                    "measureTargetLongitude=" + measureTargetLongitude +
                    ", measureTargetLatitude=" + measureTargetLatitude +
                    ", measureTargetAltitude=" + measureTargetAltitude +
                    ", measureTargetDistance=" + measureTargetDistance +
                    ", measureTargetErrorState=" + measureTargetErrorState +
                    '}';
        }

        public Double getMeasureTargetLongitude() {
            return measureTargetLongitude;
        }

        public MeasureTarget setMeasureTargetLongitude(Double measureTargetLongitude) {
            this.measureTargetLongitude = measureTargetLongitude;
            return this;
        }

        public Double getMeasureTargetLatitude() {
            return measureTargetLatitude;
        }

        public MeasureTarget setMeasureTargetLatitude(Double measureTargetLatitude) {
            this.measureTargetLatitude = measureTargetLatitude;
            return this;
        }

        public Double getMeasureTargetAltitude() {
            return measureTargetAltitude;
        }

        public MeasureTarget setMeasureTargetAltitude(Double measureTargetAltitude) {
            this.measureTargetAltitude = measureTargetAltitude;
            return this;
        }

        public Double getMeasureTargetDistance() {
            return measureTargetDistance;
        }

        public MeasureTarget setMeasureTargetDistance(Double measureTargetDistance) {
            this.measureTargetDistance = measureTargetDistance;
            return this;
        }

        public MeasureTargetStateEnum getMeasureTargetErrorState() {
            return measureTargetErrorState;
        }

        public MeasureTarget setMeasureTargetErrorState(MeasureTargetStateEnum measureTargetErrorState) {
            this.measureTargetErrorState = measureTargetErrorState;
            return this;
        }
    }
}
