package com.dji.sdk.cloudapi.debug;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author guan
 */

public enum RtkCalibrationModuleEnum {

    // {"3": "机场", "6": "中继" }
    UNKNOWN("-1"),

    // {"1": "手动标定"}
    DOCK("3"),

    RELAY("6"),
    ;

    private final String module;

    RtkCalibrationModuleEnum(String module) {
        this.module = module;
    }

    @JsonValue
    public String getModule() {
        return module;
    }

    @JsonCreator
    public static RtkCalibrationModuleEnum find(String module) {
        return Arrays.stream(RtkCalibrationModuleEnum.values())
                .filter(moduleEnum -> Objects.equals(moduleEnum.module, module))
                .findAny()
                .orElse(UNKNOWN);
    }


}
