package com.dji.sample.manage.model.receiver;

import com.dji.sdk.cloudapi.device.OsdDockDrone;
import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.Objects;

/**
 * @author sean
 * @version 1.4
 * @date 2023/3/3
 */
public class CommanderFlightHeightReceiver extends BasicDeviceProperty {

    private static final float HEIGHT_LIMIT_MAX = 1500F;

    private static final float HEIGHT_LIMIT_MIN = 20F;

    private Float commanderFlightHeight;

    @JsonCreator
    public CommanderFlightHeightReceiver(Float commanderFlightHeight) {
        this.commanderFlightHeight = commanderFlightHeight;
    }

    @Override
    public boolean valid() {
        return Objects.nonNull(this.commanderFlightHeight) && this.commanderFlightHeight >= HEIGHT_LIMIT_MIN && this.commanderFlightHeight <= HEIGHT_LIMIT_MAX;
    }

    @Override
    public boolean canPublish(OsdDockDrone osd) {
        if (osd.getCommanderFlightHeight() == null) {
            return true;
        }
        return commanderFlightHeight.floatValue() != osd.getCommanderFlightHeight();
    }
}