package com.dji.sample.uom;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 无人机飞行数据记录实体
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class UOMDroneFlightRecordDTO {

    /**
     * 飞行记录编号
     * 格式：厂商SN(8位)-起飞日期(YYYYMMDD)-8位随机码
     * 示例：1581F5FHD25G100C1SDN-20240320-owvGyLqe
     *
     * <p>
     *     厂商的无人机生产序列号（sn）－8位起飞日期（YYYYMMDD）－8位随机码（数字或字母均可）
     *     如：1581F5FHD25G100C1SDN-20240320-owvGyLqe
     * </p>
     */
    private String orderID;

    /**
     * 无人机序列号（生产序列号）
     *
     * <p>
     *     厂商的无人机生产序列号
     * </p>
     */
    private String sn;

    /**
     * 飞行状态
     * TakeOff：起飞轨迹点
     * Inflight：飞行中轨迹点 
     * Land：降落轨迹点
     *
     * <p>
     *     TakeOff：代表当前架次飞行的首个轨迹点
     *     Inflight：代表当前架次飞行中除首尾以外的其它轨迹点
     *     Land：代表当前架次飞行的最后一个轨迹点
     * </p>
     */
    private String flightStatus;

    /**
     * 厂商统一社会信用代码
     *
     * <p>
     *     生产厂商的统一社会信用代码
     * </p>
     */
    private String manufacturerID;

    /**
     * 无人驾驶航空器实名登记号
     * 默认值："UAS-DEFAULT"
     *
     * <p>
     *     若无登记号，推送默认值
     *     “UAS-DEFAULT"
     * </p>
     */
    private String uasID;

    /**
     * 当前时间（yyyyMMddHHmmss格式）
     * 示例：20240124095001
     *
     * <p>
     *     格式"yyyyMMddHHmmss"，例：20240124095001
     * </p>
     */
    private String timeStamp;

    /**
     * 产品型号（字母/数字/符号组合）
     *
     * <p>
     *     字母、数字与符号的组合
     * </p>
     */
    private String uasModel;

    /**
     * 坐标系类型
     * 1: WGS-84
     * 2: CGCS2000
     * 3: GLONASS-PZ90
     *
     * <p>
     *     1：代表WGS-84
     *     2：代表CGCS2000
     *     3：代表GLONASS-PZ90
     * </p>
     */
    private Integer coordinate;

    /**
     * 经度（单位：度）
     * 传输值=实际值×10^7
     *
     * <p>
     *     单位：度（°）
     *     精确到小数点后7位，乘10的7次方后传输
     * </p>
     */
    private Long longitude;

    /**
     * 纬度（单位：度）
     * 传输值=实际值×10^7
     *
     * <p>
     *     单位：度（°）
     *     精确到小数点后7位，乘10的7次方后传输
     * </p>
     */
    private Long latitude;

    /**
     * 真高类型
     * 1: 相对于起飞点
     * 2: 相对于当前位置
     *
     * <p>
     *     1.相对于起飞点的真高
     *     2.相对于当前位置的真高
     * </p>
     */
    private Integer heightType;

    /**
     * 真高（单位：米）
     * 传输值=实际值×10
     *
     * <p>
     *     单位：米（m）
     *     精确到小数点后1位，乘10以后传输
     * </p>
     */
    private Integer height;

    /**
     * 海拔高度（单位：米）
     * 传输值=实际值×10
     *
     * <p>
     *     单位：米（m）
     *     精确到小数点后1位，乘10以后传输
     * </p>
     */
    private Integer altitude;

    /**
     * 垂直飞行速度（m/s）
     * 传输值=实际值×10
     * <p>
     *     单位：米每秒（m/s）
     *     精确到小数点后1位，乘10后传输
     * </p>
     */
    private Integer VS;

    /**
     * 水平飞行速度（m/s）
     * 传输值=实际值×10
     *
     * <p>
     *      单位：米每秒（m/s）
     *      精确到小数点后1位，乘10后传输
     * </p>
     */
    private Integer GS;

    /**
     * 航迹角（0-360度）
     * 默认值：-999（不具备测算能力时）
     * 传输值=实际值×10
     *
     * <p>
     *      无人驾驶航空器当前时刻所在位置真北方向顺时针量至地速方向的夹角，范围（0度，360度］。
     *      暂不具备航迹角测算能力的型号产品，应报送默认值“-999”精确到小数点后1位，乘10后传输
     * </p>
     */
    private Integer course;
}