package com.dji.sdk.cloudapi.device;

import com.dji.sdk.exception.CloudSDKException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Arrays;

/**
 * @author sean
 * @version 1.7
 * @date 2023/10/20
 */
public enum EsimActivateStateEnum {

    // esim_activate_state	eSIM 激活状态	enum_int	{"0":"未知","1":"未激活","2":"已激活"}
    UNKNOWN(0),

    INACTIVATED(1),

    ACTIVATED(2),
    ;

    private final int state;

    EsimActivateStateEnum(int state) {
        this.state = state;
    }

    @JsonValue
    public int getState() {
        return state;
    }

    @JsonCreator
    public static EsimActivateStateEnum find(int state) {
        return Arrays.stream(values()).filter(stateEnum -> stateEnum.state == state).findAny()
            .orElse(UNKNOWN);
    }

}
