package com.dji.sample.manage.model.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UserDTO {

    @JsonProperty("user_id")
    private String userId;

    private String username;

    @JsonProperty("workspace_id")
    private String workspaceId;

    @JsonProperty("user_type")
    private Integer userType;

    @JsonProperty("mqtt_username")
    private String mqttUsername;

    @JsonProperty("mqtt_password")
    private String mqttPassword;

    @JsonProperty("access_token")
    private String accessToken;

    @JsonProperty("mqtt_addr")
    private String mqttAddr;

    @JsonProperty("role_type")
    private Integer roleType;

    private String email;

    private String phone;

    @JsonProperty("is_super_admin")
    private Integer isSuperAdmin;

    // 新增字段，表示用户所有关联的组织
    private List<UserOrgDTO> orgs;

    // 新增字段，表示当前选中的组织
    private String currentOrgId;
}
