package com.dji.sample.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.dji.sample.manage.dao.IOrgMapper;
import com.dji.sample.manage.model.dto.OrgDTO;
import com.dji.sample.manage.model.entity.OrgEntity;
import com.dji.sample.manage.service.IOrgService;
import org.springframework.stereotype.Service;
import com.dji.sample.common.util.SecurityUtils;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Service
@Transactional
public class OrgServiceImpl extends ServiceImpl<IOrgMapper, OrgEntity> implements IOrgService {

    @Override
    public Optional<OrgDTO> getOrgByOrgId(String orgId) {
        LambdaQueryWrapper<OrgEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(OrgEntity::getOrgId, orgId);
        
        OrgEntity entity = getOne(queryWrapper);
        if (entity == null) {
            return Optional.empty();
        }
        
        return Optional.of(convertToDTO(entity));
    }

    @Override
    public String getWorkspaceIdByOrgId(String orgId) {
        LambdaQueryWrapper<OrgEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(OrgEntity::getOrgId, orgId)
                .select(OrgEntity::getWorkspaceId);
        
        OrgEntity entity = getOne(queryWrapper);
        return entity != null ? entity.getWorkspaceId() : null;
    }

    @Override
    public boolean deleteOrg(String orgId) {
        LambdaQueryWrapper<OrgEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(OrgEntity::getOrgId, orgId);
        
        return remove(queryWrapper);
    }

    @Override
    public boolean createOrg(OrgDTO orgDTO) {
        OrgEntity entity = new OrgEntity();
        entity.setOrgId(orgDTO.getOrgId());
        entity.setOrgName(orgDTO.getOrgName());
        entity.setOrgDesc(orgDTO.getOrgDesc());
        entity.setWorkspaceId(orgDTO.getWorkspaceId());
        
        // 设置创建者和更新者信息
        String currentUserId = SecurityUtils.getUserId();
        String currentUserName = SecurityUtils.getUsername();
        
        entity.setCreatorId(currentUserId);
        entity.setCreatorName(currentUserName);
        entity.setUpdaterId(currentUserId);
        entity.setUpdaterName(currentUserName);
        
        save(entity);

        return entity.getOrgId() != null;
    }

    @Override
    public boolean updateOrg(OrgDTO orgDTO) {
        LambdaQueryWrapper<OrgEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(OrgEntity::getOrgId, orgDTO.getOrgId());
        
        OrgEntity entity = getOne(queryWrapper);
        if (entity == null) {
            return false;
        }
        
        entity.setOrgName(orgDTO.getOrgName());
        entity.setOrgDesc(orgDTO.getOrgDesc());
        entity.setWorkspaceId(orgDTO.getWorkspaceId());
        
        // 设置更新者信息
        entity.setUpdaterId(SecurityUtils.getUserId());
        entity.setUpdaterName(SecurityUtils.getUsername());

        return updateById(entity);
    }

    @Override
    public List<OrgDTO> getAllOrgs() {
        List<OrgEntity> entities = list();
        return entities.stream()
                .map(this::convertToDTO)
                .collect(Collectors.toList());
    }
    
    private OrgDTO convertToDTO(OrgEntity entity) {
        return OrgDTO.builder()
                .id(entity.getId())
                .orgId(entity.getOrgId())
                .orgName(entity.getOrgName())
                .orgDesc(entity.getOrgDesc())
                .workspaceId(entity.getWorkspaceId())
                // .createTime(entity.getCreateTime())
                // .updateTime(entity.getUpdateTime())
                .build();
    }
}
