package com.dji.sdk.cloudapi.debug;

import com.dji.sdk.cloudapi.control.Point;

/**
 * @author guan
 */
public class RtkCalibrationRequestData {

    /**
     * 设备序列号
     */
    private String sn;

    /**
     * 标定类型
     */
    RtkCalibrationTypeEnum type;

    /**
     * 模块枚举值
     */
    RtkCalibrationModuleEnum module;

    /**
     * 标定数据
     */
    Point data;
    //» data	标定数据	struct
    //»» longitude	经度	double
    //»» latitude	纬度	double
    //»» height	高度	double

    @Override
    public String toString() {
        return "RtkCalibrationRequestData{" +
                "sn=" + sn +
                ", type=" + type +
                ", module=" + module +
                ", data=" + data +
                '}';
    }

    public String getSn() {
        return sn;
    }

    public RtkCalibrationRequestData setSn(String sn) {
        this.sn = sn;
        return this;
    }

    public RtkCalibrationTypeEnum getType() {
        return type;
    }

    public RtkCalibrationRequestData setType(RtkCalibrationTypeEnum type) {
        this.type = type;
        return this;
    }

    public RtkCalibrationModuleEnum getModule() {
        return module;
    }

    public RtkCalibrationRequestData setModule(RtkCalibrationModuleEnum module) {
        this.module = module;
        return this;
    }

    public Point getData() {
        return data;
    }

    public RtkCalibrationRequestData setData(Point data) {
        this.data = data;
        return this;
    }

}
