import csv
import os
import time
from datetime import datetime
from datetime import datetime
from ftplib import FTP
import socket
import io
import pandas as pd
from io import BytesIO
import paho.mqtt.client as mqtt
import json

# MQTT服务器地址和端口
broker = "iot.raytue.com"
port = 1883

# 客户端ID
client_id = "S&D23ANR8041JQI&157&23"
userName="raytue"
passWord="P14AX03XD7W9G42Z"
# 发布主题
topic = "/157/D23ANR8041JQI/property/post"


# FTP服务器配置
FTP_SERVER = 'iot.raytue.com'
FTP_USER = 'tsensing'
FTP_PASS = 'tsensing!@#123'
FTP_DIR = '/tilt/170058(TM9)/'  # FTP服务器上的目标目录，根据实际情况修改

def connect_ftp():
    try:
        ftp = FTP()
        ftp.connect(FTP_SERVER)  # 设置连接超时
        ftp.login(FTP_USER, FTP_PASS)
        #ftp.set_pasv(True)
        ftp.cwd(FTP_DIR)
        print(f"TM9成功连接 {FTP_SERVER}:{21}")
        return ftp
    except socket.timeout:
        print("TM9连接超时，请检查网络或服务器状态")
    except Exception as e:
        print(f"TM9连接失败: {str(e)}")


def del_file(list_row):
    # print(list_row[10])
    number_row= len(list_row)
    mqttstr=""
    print("TM9列表中有",number_row,"行")
    j=10

    # if list_row[10][0] == "Time":#有的表格第10行不是数据是表头
    #     j=11

    for i in range(number_row):
        if list_row[i][0] == "Time":
            j=i+1
            break
    i=0
    for i in range(j,number_row): 
        #格式化mqtt字符串
        mqttstr="[{\"id\":\"tiltData_time\",\"remark\":\"\",\"value\":\"%s\"},{\"id\":\"tiltData_dPitch\",\"remark\":\"\",\"value\":\"%s\"},{\"id\":\"tiltData_dRoll\",\"remark\":\"\",\"value\":\"%s\"}]" % (list_row[i][0] ,list_row[i][5] ,list_row[i][6] )
        # print(mqttstr)

        # payload = json.dumps(mqttstr)
        payload = mqttstr
        # 发布消息
        result = client.publish(topic, payload)
        # 检查消息是否成功发布
        status = result[0]
        if status == 0:
            print(f"TM9Send `{payload}` to topic `{topic}`")
        else:
            print(f"TM9Failed to send message to topic {topic}")
        time.sleep(1)



def monitor_directory(known_files,interval=60):
    """
    监控指定目录的新增文件
    """
    #known_files=[]#首次全部传输完成后注释掉
    while True:
        ftp = connect_ftp()
        ftp.cwd(FTP_DIR)
        # 获取当前文件列表
        try:
              #ftp.set_pasv(True)
              current_files = ftp.nlst()#读文件列表
              print('TM9当前目录------------>：')
              # print(current_files)
              # 找出新增文件
              #new_files = current_files - known_files
              new_files = [item for item in current_files if item not in known_files]
              print('TM9新增文件--------->：')
              print(new_files)
              #new_files = ['44444444.csv']
              if new_files:
                  print(f"[{datetime.now()}] 发现 {len(new_files)} 个新文件:")
                  for filename in new_files:
                      #filepath = os.path.join(directory, filename)
                      print(f"TM9分析文件: {filename}")
                      #analyze_file(filepath)

                      for i in range(10):  # 从0到4  防止掉线读不出来
                        # 使用BytesIO作为文件缓冲区
                        try:
                          print(f"TM9第{i}次读取")                            
                          ftp = connect_ftp()
                          ftp.cwd(FTP_DIR)
                          file_data = io.BytesIO()
                          ftp.retrbinary(f"RETR {filename}", file_data.write)
                          file_data.seek(0)
                          csv_data = file_data.read().decode('utf-8')
                          csv_reader = csv.reader(io.StringIO(csv_data))
                          #csv_reader = csv.reader(csv_data)
                          list_row = list(csv_reader)
                          del_file(list_row)#处理数据
                          # for row in csv_reader:
                          #   del_file(row)#处理数据
                          break
                        except  Exception as e:
                            print(f"TM9读取文件{filename}出错: {e}") 
                            if i == 9:
                                i = 0
                            continue 
                  print("--------------------------------全部文件发送完毕------------------------------------------")#首次全部传输完成后，注释掉
                  #return#首次全部传输完成后，注释掉
                      # 打印文件内容
                      #content = file_data.read().decode('utf-8')
                      #print(content)
              
              # 更新已知文件列表
              known_files = current_files
              ftp.quit()
        except  Exception as e:
              print(f"TM9读取当前目录出错: {e}")        
               
        # 等待下次检查
        time.sleep(interval)

def analyze_file(filepath):
    """
    分析文件内容
    :param filepath: 文件路径
    """
    try:
        with open(filepath, 'r', encoding='utf-8') as f:
            content = f.read()
            # 这里可以添加你的分析逻辑
            print(f"TM9文件大小: {len(content)} 字节")
            #print(f"首100字符: {content[:100]}...")
    except Exception as e:
        print(f"TM9读取文件 {filepath} 出错: {str(e)}")


# 连接回调函数
def on_connect1(client, userdata, flags, reason_code, properties):
    if reason_code == 0:
        print("TM9Connected to MQTT Broker!")
    else:
        print(f"TM9Failed to connect, return code {reason_code}")


if __name__ == "__main__":
    

    # 创建MQTT客户端实例
    client = mqtt.Client(mqtt.CallbackAPIVersion.VERSION2, client_id)
    #client = mqtt.Client(client_id)
    client.on_connect = on_connect1
    client.username_pw_set(userName, passWord)
    # 连接到MQTT服务器
    client.connect(broker, port, 60)
    # 开始循环
    client.loop_start()

    # 初始文件列表

    while True:
      try:
            ftp = connect_ftp()
            ftp.cwd(FTP_DIR)
            #ftp.set_pasv(True)
            known_files = ftp.nlst()
            print('TM9初始目录：')
            #print(known_files)
            ftp.quit()
            monitor_directory(known_files,10)
      except  Exception as e:
            print(f"TM9读取初始目录出错: {e}")
      time.sleep(5)

    
