package com.dji.sample.common.util;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.dji.sample.common.model.CustomClaim;
import com.dji.sample.manage.model.enums.UserTypeEnum;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

import static com.dji.sample.component.AuthInterceptor.PARAM_TOKEN;

/**
 * @author guan
 */
public class SecurityUtils {

    /**
     * 生成BCryptPasswordEncoder密码
     *
     * @param password 密码
     * @return 加密字符串
     */
    public static String encryptPassword(String password) {
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return passwordEncoder.encode(password);
    }

    /**
     * 判断密码是否相同
     *
     * @param rawPassword 真实密码
     * @param encodedPassword 加密后字符
     * @return 结果
     */
    public static boolean matchesPassword(String rawPassword, String encodedPassword) {
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return passwordEncoder.matches(rawPassword, encodedPassword);
    }

    /**
     * 判断当前用户是否admin
     * @return
     */
    public static boolean isAdmin() {

        DecodedJWT jwt = JwtUtil.verifyToken(getToken());
        CustomClaim customClaim = new CustomClaim(jwt.getClaims());

        Integer userType = customClaim.getUserType();
        if (userType == null) {
            return false;
        }

        return userType == UserTypeEnum.WEB.getVal();
    }

    public static boolean isNotAdmin() {
        return !isAdmin();
    }

    /**
     * 获取token
     * @return
     */
    public static String getToken() {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();

        return request.getHeader(PARAM_TOKEN);
    }

}
