package com.dji.sdk.cloudapi.debug;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Arrays;

/**
 * @author guan
 */

public enum RtkCalibrationTypeEnum {

    UNKNOWN(-1),

    // {"1": "手动标定"}
    MANUAL(1),
    ;

    private final int type;

    RtkCalibrationTypeEnum(int type) {
        this.type = type;
    }

    @JsonValue
    public int getType() {
        return type;
    }

    @JsonCreator
    public static RtkCalibrationTypeEnum find(int type) {
        return Arrays.stream(RtkCalibrationTypeEnum.values()).filter(typeEnum -> typeEnum.type == type).findAny()
                .orElse(UNKNOWN);
    }
}
