package com.dji.sample.wayline.model.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * 任务创建原因
 * @author guan
 */
@Getter
public enum TaskSceneEnum {

    MODEL_TASK(0, "建模任务"),

    ROUTINE_PATROL_TASK(1, "常规巡查任务"),

    TEMPORARY_TAKEOFF_TASK(2, "临时起飞任务");

    int scene;

    String sceneName;

    TaskSceneEnum(int scene, String sceneName) {
        this.scene = scene;
        this.sceneName = sceneName;
    }

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    public static TaskSceneEnum find(Integer scene) {
        return Arrays.stream(values()).filter(taskSceneEnum -> taskSceneEnum.scene == scene).findAny().get();
    }

    public static Optional<TaskSceneEnum> find(String sceneName) {
        return Arrays.stream(values()).filter(taskSceneEnum -> taskSceneEnum.sceneName.equals(sceneName)).findAny();
    }

}
