package com.dji.sample.manage.controller;

import com.dji.sample.common.model.CustomClaim;
import com.dji.sample.manage.model.dto.OrgDTO;
import com.dji.sample.manage.model.dto.UserOrgDTO;
import com.dji.sample.manage.model.param.searchParam.OrgSearchParam;
import com.dji.sample.manage.service.IOrgService;
import com.dji.sample.manage.service.IUserOrgService;
import com.dji.sdk.common.HttpResultResponse;
import com.dji.sdk.common.PaginationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Optional;

import static com.dji.sample.common.util.SecurityUtils.*;
import static com.dji.sample.component.AuthInterceptor.TOKEN_CLAIM;

@RestController
@RequestMapping("${url.manage.prefix}${url.manage.version}/orgUser")
public class UserOrgController {

    @Autowired
    private IUserOrgService userOrgService;


    @PostMapping("/addUserToOrg")
    public HttpResultResponse addUserToOrg(@RequestBody UserOrgDTO userOrgDTO) {

        // 判断权限 管理员才允许新增
        aboveAdminRoleAndThrowError();

        boolean isAdd = userOrgService.addUserToOrg(userOrgDTO.getUserId(), userOrgDTO.getOrgId(), userOrgDTO.getRoleType());

        return isAdd ? HttpResultResponse.success() : HttpResultResponse.error();
    }

    @PostMapping("/removeUserFromOrg")
    public HttpResultResponse removeUserFromOrg(@RequestBody UserOrgDTO userOrgDTO) {

        // 判断权限 管理员才允许删除
        aboveAdminRoleAndThrowError();

        boolean isDel = userOrgService.removeUserFromOrg(userOrgDTO.getUserId(), userOrgDTO.getOrgId());

        return isDel ? HttpResultResponse.success() : HttpResultResponse.error();
    }

}