package com.dji.sample.control.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.dji.sample.control.model.entity.ManageDeviceOperatingRecord;
import com.dji.sample.control.dao.IManageDeviceOperatingRecordMapper;
import com.dji.sample.control.service.IManageDeviceOperatingRecordService;
import lombok.SneakyThrows;
import org.springframework.stereotype.Service;

import static com.dji.sample.common.util.IPUtils.getIpAddr;
import static com.dji.sample.common.util.SecurityUtils.getUserId;
import static com.dji.sample.common.util.SecurityUtils.getWorkspaceId;

/**
 * @author guan
 */
@Service
public class ManageDeviceOperatingRecordServiceImpl extends ServiceImpl<IManageDeviceOperatingRecordMapper, ManageDeviceOperatingRecord> implements IManageDeviceOperatingRecordService {

    @SneakyThrows
    @Override
    public ManageDeviceOperatingRecord saveOperatingRecord(String sn, String operatingType, String paramStr) {
        ManageDeviceOperatingRecord record = new ManageDeviceOperatingRecord();
        record.setDockSn(sn);
        record.setOperatingParam(paramStr);
        record.setOperatingTime(System.currentTimeMillis());
        record.setWorkspaceId(getWorkspaceId());
        record.setUserId(getUserId());
        record.setOperatingType(operatingType);
        record.setIp(getIpAddr());

        return record;
    }
}
