package com.dji.sample.uom;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
@Slf4j
@Service
public class UOMRecordService {

    @Autowired
    private UOMConfiguration uomConfiguration;
    /*
    * {
	"appID":"104807e9161a4804b35d",
	"paths":[
	{
        "orderID":"ZTU25VA2204FSUHXT-20240204-17070329",
        "sn":"ZTU25VA2204FSUHXT",
        "flightStatus":"Land",
        "manufacturerID":"91310106575864243X",
        "uasID":"xxxxxxx",
        "timeStamp":"20240124095001",
        "uasModel":"ZT-25",
        "coordinate":1,
        "longitude":1154458272,
        "latitude":401929176,
        "heightType":1,
        "height":130,
        "altitude":130,
        "VS":30,
        "GS":118,
        "course":680，
	}
	]
}
    * */
    public String sendRecord(UOMDroneFlightRecordDTO uomDroneFlightRecordDTO) throws Exception {
        SendUOMDTO sendUOMDTO = new SendUOMDTO();
        sendUOMDTO.setAppID(uomConfiguration.getAppID());
        List<UOMDroneFlightRecordDTO> paths = sendUOMDTO.getPaths();
        paths.add(uomDroneFlightRecordDTO);
        HttpRequest post = HttpUtil.createPost(uomConfiguration.getUrl());
        post.header("source", String.valueOf(uomConfiguration.getSource()));
        post.header("platform", uomConfiguration.getPlatform());
        post.header("programVersion", uomConfiguration.getProgramVersion());
        String encrypt = SM3Util.encrypt(JSONUtil.toJsonStr(sendUOMDTO), uomConfiguration.getAppKey());
        post.header("signature",encrypt);
        post.header("Content-Type","application/json");
        sendUOMDTO.setPaths(paths);
        post.body(JSONUtil.toJsonStr(sendUOMDTO));
        log.info("UOM Record: " + JSONUtil.toJsonStr(sendUOMDTO));
        return post.execute().body();
    }


}
