package com.dji.sample.manage.model.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * The entity class of the fleet
 *
 * @author guan
 * @version 0.1
 * @date 2025/4/21
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "manage_fleet")
public class FleetEntity implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @TableField(value = "fleet_sn")
    private String fleetSn;

    @TableField(value = "fleet_name")
    private String fleetName;

    @TableField(value = "workspace_id")
    private String workspaceId;

    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Long createTime;

    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Long updateTime;

    @TableField(value = "fleet_desc")
    private String fleetDesc;

    @TableField(value = "user_id")
    private String userId;

    @TableField(value = "nickname")
    private String nickname;

}