package com.dji.sample.manage.controller;

import com.dji.sample.manage.model.dto.DeviceDTO;
import com.dji.sample.manage.model.dto.FleetDTO;
import com.dji.sample.manage.service.IFleetService;
import com.dji.sdk.common.HttpResultResponse;
import com.dji.sdk.common.PaginationData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author guan
 */
@RestController
@Slf4j
@RequestMapping("${url.manage.prefix}${url.manage.version}/fleet")
public class FleetController {

    @Autowired
    private IFleetService fleetService;

    @GetMapping("/{workspace_id}/getFleetPage")
    public HttpResultResponse<PaginationData<FleetDTO>> getFleets(@PathVariable("workspace_id") String workspaceId,
                                                                  @RequestParam(defaultValue = "1") Long page,
                                                                  @RequestParam(value = "page_size", defaultValue = "50") Long pageSize) {
        PaginationData<FleetDTO> fleetsList = fleetService.getFleetPage(workspaceId, page, pageSize);

        return HttpResultResponse.success(fleetsList);
    }

    @GetMapping("/{workspace_id}/getFleetBySn")
    public HttpResultResponse<FleetDTO> getFleetBySn(@PathVariable("workspace_id") String workspaceId,
                                                     @RequestParam("fleet_sn") String fleetSn) {
        FleetDTO fleetDTO = fleetService.getFleetBySn(workspaceId, fleetSn);

        return HttpResultResponse.success(fleetDTO);
    }


    @PostMapping("/{workspace_id}/addFleet")
    public HttpResultResponse addFleet(@RequestBody FleetDTO fleet, @PathVariable("workspace_id") String workspaceId) {

        fleet.setWorkspaceId(workspaceId);
        boolean isAdd = fleetService.addFleet(fleet);

        return isAdd ? HttpResultResponse.success() : HttpResultResponse.error();
    }

    @PostMapping("/{workspace_id}/editFleet")
    public HttpResultResponse editFleet(@RequestBody FleetDTO fleet, @PathVariable("workspace_id") String workspaceId) {

        fleet.setWorkspaceId(workspaceId);
        boolean isEdit = fleetService.editFleet(fleet);

        return isEdit ? HttpResultResponse.success() : HttpResultResponse.error();
    }

    /**
     * Removing the fleet
     * @param fleetSn
     * @return
     */
    @DeleteMapping("/{fleet_sn}/delete")
    public HttpResultResponse deleteFleet(@PathVariable("fleet_sn") String fleetSn) {
        boolean isDel = fleetService.deleteFleet(fleetSn);
        return isDel ? HttpResultResponse.success() : HttpResultResponse.error();
    }

    /**
     * Removing the fleet.
     * @param workspaceId
     * @param id
     * @return
     */
    @DeleteMapping("/{workspace_id}/deleteFleetById")
    public HttpResultResponse deleteFleetById(@PathVariable("workspace_id") String workspaceId,
                                               @RequestParam(name = "id") Integer id) {
        boolean isDel = fleetService.deleteFleetById(workspaceId, id);
        return isDel ? HttpResultResponse.success() : HttpResultResponse.error();

    }

}
