package com.dji.sample.manage.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.dji.sample.manage.model.dto.WorkspaceDTO;
import com.dji.sample.manage.model.entity.WorkspaceEntity;
import com.dji.sample.manage.model.param.searchParam.WorkspaceSearchParam;
import com.dji.sdk.common.PaginationData;

import java.util.Optional;

public interface IWorkspaceService extends IService<WorkspaceEntity> {

    /**
     * Query the information of a workspace based on its workspace id.
     * @param workspaceId
     * @return
     */
    Optional<WorkspaceDTO> getWorkspaceByWorkspaceId(String workspaceId);

    /**
     * Query the workspace of a workspace based on bind code.
     * @param bindCode
     * @return
     */
    Optional<WorkspaceDTO> getWorkspaceNameByBindCode(String bindCode);

    PaginationData<WorkspaceDTO> getWorkspacePage(WorkspaceSearchParam param, Long page, Long pageSize);

    WorkspaceDTO addWorkspace(WorkspaceDTO addWorkspace);

    boolean editWorkspace(WorkspaceDTO editWorkspace);

    boolean delWorkspaceById(Integer id);

    boolean delWorkspaceByWorkspaceId(String workspaceId);

    WorkspaceDTO getWorkspace(WorkspaceSearchParam param);

}
