package com.dji.sample.manage.model.receiver;

import com.dji.sdk.cloudapi.control.CommanderFlightModeEnum;
import com.dji.sdk.cloudapi.control.CommanderModeLostActionEnum;
import com.dji.sdk.cloudapi.device.OsdDockDrone;
import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.Objects;

/**
 * @author sean
 * @version 1.4
 * @date 2023/3/3
 */
public class CommanderFlightModeReceiver extends BasicDeviceProperty {

    private CommanderFlightModeEnum commanderFlightMode;

    @JsonCreator
    public CommanderFlightModeReceiver(Integer commanderFlightMode) {
        this.commanderFlightMode = CommanderFlightModeEnum.find(commanderFlightMode);
    }

    @Override
    public boolean valid() {
        return Objects.nonNull(commanderFlightMode);
    }

    @Override
    public boolean canPublish(OsdDockDrone osd) {
        return commanderFlightMode != osd.getCommanderFlightMode();
    }
}
