package com.dji.sample.manage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.dji.sample.manage.model.dto.UserDTO;
import com.dji.sample.manage.model.dto.UserListDTO;
import com.dji.sample.manage.model.entity.UserEntity;
import com.dji.sdk.common.HttpResultResponse;
import com.dji.sdk.common.PaginationData;

import java.util.Optional;

public interface IUserService extends IService<UserEntity> {

    /**
     * Query user's details based on username.
     * @param username
     * @param workspaceId
     * @return
     */
    HttpResultResponse getUserByUsername(String username, String workspaceId);

    /**
     * Verify the username and password to log in.
     * @param username
     * @param password
     * @param flag
     * @return
     */
    HttpResultResponse userLogin(String username, String password, Integer flag);

    /**
     * Create a user object containing a new token.
     * @param token
     * @return
     */
    Optional<UserDTO> refreshToken(String token);

    /**
     * Query information about all users in a workspace.
     * @param workspaceId   uuid
     * @return
     */
    PaginationData<UserListDTO> getUsersByWorkspaceId(long page, long pageSize, String workspaceId);

    Boolean updateUser(String workspaceId, String userId, UserListDTO user);

    Boolean deleteUser(String workspaceId, String userId);

    Boolean addUser(String workspaceId, UserEntity user);

    /**
     * Query user's details based on userId
     * @param username
     * @param workspaceId
     * @return
     */
    HttpResultResponse getUserByUserId(String username, String workspaceId);

}
