package com.dji.sample.manage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.dji.sample.manage.model.dto.OrgDTO;
import com.dji.sample.manage.model.dto.OrgJoinDTO;
import com.dji.sample.manage.model.dto.WorkspaceDTO;
import com.dji.sample.manage.model.entity.OrgEntity;
import com.dji.sample.manage.model.param.searchParam.OrgSearchParam;
import com.dji.sample.manage.model.param.searchParam.WorkspaceSearchParam;
import com.dji.sdk.common.PaginationData;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Optional;

public interface IOrgService extends IService<OrgEntity> {

    /**
     * 根据组织ID获取组织信息
     * @param orgId 组织ID
     * @return 组织信息
     */
    Optional<OrgDTO> getOrgByOrgId(String orgId);

    PaginationData<OrgDTO> getOrgPage(OrgSearchParam param, Long page, Long pageSize);

    OrgDTO addOrg(OrgDTO orgDTO);
    boolean editOrg(OrgDTO orgDTO);

    boolean delOrg(OrgDTO orgDTO);

    /**
     * 用户申请加入团队
     * @param orgDTO
     * @return
     */
    boolean applyOrg(OrgJoinDTO orgDTO);

    /**
     * 管理员增加团队
     * @param orgDTO
     * @return
     */
    boolean joinOrgByAdmin(OrgJoinDTO orgDTO);

    OrgDTO getOrg(OrgSearchParam param);

    /**
     * 获取组织对应的workspaceId
     * @param orgId 组织ID
     * @return workspaceId
     */
    String getWorkspaceIdByOrgId(String orgId);

    /**
     * 获取所有组织列表
     * @return 组织列表
     */
    List<OrgDTO> getAllOrgs();

    /**
     * 删除组织
     * @param orgId 组织ID
     * @return 是否删除成功
     */
    boolean deleteOrg(String orgId);

    /**
     * 创建组织
     * @param orgDTO 组织实体
     * @return 是否创建成功
     */
    boolean createOrg(OrgDTO orgDTO);

    /**
     * 更新组织
     * @param orgDTO 组织实体
     * @return 是否更新成功
     */
    boolean updateOrg(OrgDTO orgDTO);

    String saveLogo(MultipartFile file);

    String getLogo();

}
