package com.dji.sample.manage.model.enums;

/**
 * 角色类型
 * @author guan
 */
public enum RoleTypeEnum {

    MEMBER(0, "成员"),

    ADMIN(1, "管理员"),

    PILOT(2, "飞手"),

    SYS_ADMIN(100, "系统管理员"),

    UNKNOWN(-1, "Unknown");

    private int val;

    private String desc;

    RoleTypeEnum(int val, String desc) {
        this.val = val;
        this.desc = desc;
    }

    public int getVal() {
        return this.val;
    }

    public String getDesc() {
        return this.desc;
    }

    public static RoleTypeEnum find(int val) {
        if (val == SYS_ADMIN.val) {
            return SYS_ADMIN;
        }
        if (val == ADMIN.val) {
            return ADMIN;
        }
        if (val == PILOT.val) {
            return PILOT;
        }
        if (val == MEMBER.val) {
            return MEMBER;
        }
        return UNKNOWN;
    }
}
