package com.dji.sample.ai.controller;

import com.dji.sample.ai.model.dto.AiInfoDTO;
import com.dji.sample.ai.model.param.AiInfoSearchParam;
import com.dji.sample.ai.service.IAiInfoService;
import com.dji.sample.common.model.CustomClaim;
import com.dji.sample.control.model.enums.DroneAuthorityEnum;
import com.dji.sample.control.model.enums.RemoteDebugMethodEnum;
import com.dji.sample.control.model.param.*;
import com.dji.sample.control.service.IControlService;
import com.dji.sample.manage.model.dto.UserListDTO;
import com.dji.sample.manage.model.entity.UserEntity;
import com.dji.sdk.common.HttpResultResponse;
import com.dji.sdk.common.PaginationData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

import static com.dji.sample.component.AuthInterceptor.TOKEN_CLAIM;


/**
 * @author gdj
 * @version 1.0
 * @date 20225/7/2
 */
@RestController
@Slf4j
@RequestMapping("${url.manage.prefix}${url.manage.version}/aiInfo")
public class AiInfoController {

    @Autowired
    private IAiInfoService aiInfoService;

    /**
     * Paging to query all users in a workspace.
     * @param param      param
     * @param page      current page
     * @param pageSize pageSize
     * @return
     */
    @GetMapping("/Page")
    public HttpResultResponse<PaginationData<AiInfoDTO>> getAiInfoPage(AiInfoSearchParam param,
                                                                       @RequestParam(defaultValue = "1") Long page,
                                                                       @RequestParam(value = "page_size", defaultValue = "50") Long pageSize) {
        PaginationData<AiInfoDTO> paginationData = aiInfoService.getAiInfoPageByParam(param, page, pageSize);
        return HttpResultResponse.success(paginationData);
    }

}
