package com.dji.sample.manage.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.dji.sample.manage.model.dto.UserOrgDTO;
import com.dji.sample.manage.model.entity.UserOrgEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface IUserOrgMapper extends BaseMapper<UserOrgEntity> {
    
    /**
     * 查询用户所有关联的组织信息，包含组织名称
     * @param userId 用户ID
     * @return 用户组织列表（包含组织名称）
     */
    @Select("SELECT uo.*, o.org_name FROM manage_user_org uo " +
            "LEFT JOIN manage_org o ON uo.org_id = o.org_id " +
            "WHERE uo.user_id = #{userId} AND uo.status = 1")
    List<UserOrgDTO> selectUserOrgs(@Param("userId") String userId);
}
