package com.dji.sample.manage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.dji.sample.manage.model.dto.UserOrgDTO;
import com.dji.sample.manage.model.entity.UserOrgEntity;

import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface IUserOrgService extends IService<UserOrgEntity> {

    /**
     * 获取用户在特定组织的角色信息
     * @param userId 用户ID
     * @param orgId 组织ID
     * @return 用户组织关联信息
     */
    Optional<UserOrgEntity> getUserOrg(String userId, String orgId);
    
    /**
     * 获取用户的所有组织信息
     * @param userId 用户ID
     * @return 用户所有组织关联信息列表
     */
    List<UserOrgDTO> getUserOrgs(String userId);
    
    /**
     * 获取特定组织中所有用户ID
     * @param orgId 组织ID
     * @return 用户ID列表
     */
    List<String> getUserIdsByOrgId(String orgId);
    
    /**
     * 获取组织中所有用户的角色映射
     * @param orgId 组织ID
     * @return 用户ID与角色类型的映射
     */
    Map<String, Integer> getUserRoleMapByOrgId(String orgId);
    
    /**
     * 添加用户到组织
     * @param userId 用户ID
     * @param orgId 组织ID
     * @param roleType 角色类型
     * @return 操作是否成功
     */
    boolean addUserToOrg(String userId, String orgId, Integer roleType);
    
    /**
     * 从组织移除用户
     * @param userId 用户ID
     * @param orgId 组织ID
     * @return 操作是否成功
     */
    boolean removeUserFromOrg(String userId, String orgId);
    
    /**
     * 更新用户在组织的角色
     * @param userId 用户ID
     * @param orgId 组织ID
     * @param roleType 新的角色类型
     * @return 操作是否成功
     */
    boolean updateUserOrgRole(String userId, String orgId, Integer roleType);
}
