package com.dji.sample.wayline.model.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author guan
 * @version 9.23
 * @date 2025/3/21
 */
public enum WaylineFileTypeEnum {

    FILE(0, "file"),

    DIRECTORY(1, "directory");

    int val;

    String type;

    WaylineFileTypeEnum(int val, String type) {
        this.val = val;
        this.type = type;
    }

    @JsonValue
    public int getVal() {
        return val;
    }

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    public static WaylineFileTypeEnum find(Integer val) {
        return Arrays.stream(values()).filter(fileTypeEnum -> fileTypeEnum.val == val).findAny().get();
    }

    public static Optional<WaylineFileTypeEnum> find(String type) {
        return Arrays.stream(values()).filter(fileTypeEnum -> fileTypeEnum.type.equals(type)).findAny();
    }
}
