package com.dji.sample.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.dji.sample.manage.dao.IFleetUserMapper;
import com.dji.sample.manage.model.dto.FleetUserDTO;
import com.dji.sample.manage.model.entity.FleetUserEntity;
import com.dji.sample.manage.model.entity.UserEntity;
import com.dji.sample.manage.model.enums.UserTypeEnum;
import com.dji.sample.manage.service.IFleetUserService;
import com.dji.sample.manage.service.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author guan
 */
@Service
@Transactional
public class FleetUserServiceImpl extends ServiceImpl<IFleetUserMapper, FleetUserEntity> implements IFleetUserService {

    @Autowired
    private IFleetUserMapper mapper;

    @Autowired
    private IUserService userService;

    @Override
    public void addFleetUser(List<FleetUserEntity> userList) {

        for (FleetUserEntity addUser : userList) {
            this.mapper.insert(addUser);
        }

    }

    @Override
    public List<FleetUserDTO> searchUserDTOListByFleetId(String fleetId) {

        LambdaQueryWrapper<FleetUserEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(FleetUserEntity::getFleetId, fleetId);

        List<FleetUserEntity> fleetUserEntities = this.mapper.selectList(queryWrapper);

        List<FleetUserDTO> userDTOList = new ArrayList<>();
        for (FleetUserEntity fleetUserEntity : fleetUserEntities) {
            userDTOList.add(fleetUserEntityToDTO(fleetUserEntity));
        }
        return userDTOList;
    }

    @Override
    public List<FleetUserDTO> searchUserDTOListByFleetIds(List<Integer> fleetIds) {
        if (CollectionUtils.isEmpty(fleetIds)) {
            return new ArrayList<>();
        }
        LambdaQueryWrapper<FleetUserEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(FleetUserEntity::getFleetId, fleetIds);
        List<FleetUserEntity> fleetUserEntities = this.list(queryWrapper);

        List<FleetUserDTO> userDTOList = fleetUserEntityToDTOList(fleetUserEntities);
        return userDTOList;
    }

    public FleetUserDTO fleetUserEntityToDTO(FleetUserEntity entity) {

        FleetUserDTO fleetUserDTO = new FleetUserDTO();

        fleetUserDTO.setId(entity.getId());
        fleetUserDTO.setFleetId(entity.getFleetId());
        fleetUserDTO.setUserId(entity.getUserId());

        // 查询 user
        LambdaQueryWrapper<UserEntity> userQueryWrapper = new LambdaQueryWrapper<>();
        userQueryWrapper.eq(UserEntity::getId, fleetUserDTO.getUserId());
        UserEntity user = userService.getOne(userQueryWrapper);

        if (!ObjectUtils.isEmpty(user)) {
            fleetUserDTO.setUsername(user.getUsername());
            fleetUserDTO.setUserTypeName(UserTypeEnum.find(user.getUserType()).name());
        }

        return fleetUserDTO;
    }

    public List<FleetUserDTO> fleetUserEntityToDTOList(List<FleetUserEntity> entityList) {

        List<FleetUserDTO> fleetUserDTOList = new ArrayList<>();

        if (CollectionUtils.isEmpty(entityList)) {
            return fleetUserDTOList;
        }
        List<String> userIdList = entityList.stream().map(FleetUserEntity::getUserId).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userIdList)) {
            return fleetUserDTOList;
        }
        // 查询 user
        LambdaQueryWrapper<UserEntity> userQueryWrapper = new LambdaQueryWrapper<>();
        userQueryWrapper.in(UserEntity::getId, userIdList);
        List<UserEntity> userEntityList = userService.list(userQueryWrapper);
        Map<Integer, UserEntity> userEntityMap = userEntityList.stream().collect(Collectors.toMap(UserEntity::getId, Function.identity(), (key1, key2) -> key1));

        for (FleetUserEntity entity : entityList) {
            FleetUserDTO fleetUserDTO = new FleetUserDTO();
            fleetUserDTO.setId(entity.getId());
            fleetUserDTO.setFleetId(entity.getFleetId());
            fleetUserDTO.setUserId(entity.getUserId());

            UserEntity user = userEntityMap.getOrDefault(Integer.valueOf(entity.getUserId()), null);
            if (!ObjectUtils.isEmpty(user)) {
                fleetUserDTO.setUsername(user.getUsername());
                fleetUserDTO.setUserTypeName(UserTypeEnum.find(user.getUserType()).name());
            }

            fleetUserDTOList.add(fleetUserDTO);
        }

        return fleetUserDTOList;
    }

}
