package com.dji.sample.manage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.dji.sample.manage.model.dto.OrgDTO;
import com.dji.sample.manage.model.entity.OrgEntity;

import java.util.List;
import java.util.Optional;

public interface IOrgService extends IService<OrgEntity> {

    /**
     * 根据组织ID获取组织信息
     * @param orgId 组织ID
     * @return 组织信息
     */
    Optional<OrgDTO> getOrgByOrgId(String orgId);
    
    /**
     * 获取组织对应的workspaceId
     * @param orgId 组织ID
     * @return workspaceId
     */
    String getWorkspaceIdByOrgId(String orgId);
    
    /**
     * 获取所有组织列表
     * @return 组织列表
     */
    List<OrgDTO> getAllOrgs();

    /**
     * 删除组织
     * @param orgId 组织ID
     * @return 是否删除成功
     */
    boolean deleteOrg(String orgId);
    
    /**
     * 创建组织
     * @param orgEntity 组织实体
     * @return 是否创建成功
     */
    boolean createOrg(OrgDTO orgDTO);

    /**
     * 更新组织
     * @param orgEntity 组织实体
     * @return 是否更新成功
     */
    boolean updateOrg(OrgDTO orgDTO);
}
