package com.dji.sample.wayline.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.dji.sample.wayline.model.dto.WaylineFileDTO;
import com.dji.sample.wayline.model.dto.WaylineFileTreeVO;
import com.dji.sample.wayline.model.entity.WaylineFileEntity;
import com.dji.sample.wayline.model.param.WaylineSearchParam;
import com.dji.sdk.cloudapi.wayline.GetWaylineListRequest;
import com.dji.sdk.cloudapi.wayline.GetWaylineListResponse;
import com.dji.sdk.common.PaginationData;
import org.springframework.web.multipart.MultipartFile;

import java.net.URL;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

/**
 * @author sean
 * @version 0.3
 * @date 2021/12/22
 */
public interface IWaylineFileService extends IService<WaylineFileEntity> {

    /**
     * Perform paging queries based on query parameters.
     * @param workspaceId
     * @param param
     * @return
     */
    PaginationData<GetWaylineListResponse> getWaylinesByParam(String workspaceId, GetWaylineListRequest param);

    /**
     * Query the information of this wayline file according to the wayline file id.
     * @param workspaceId
     * @param waylineId
     * @return
     */
    Optional<GetWaylineListResponse> getWaylineByWaylineId(String workspaceId, String waylineId);

    /**
     * Get the download address of the file object.
     * @param workspaceId
     * @param waylineId
     * @return
     */
    URL getObjectUrl(String workspaceId, String waylineId) throws SQLException;

    /**
     * Get the download address of the file object.
     * @param workspaceId
     * @param waylineId
     * @return
     */
    URL getObjectLocalUrl(String workspaceId, String waylineId) throws SQLException;

    /**
     * Get the download address of the file object.
     * @param workspaceId
     * @param waylineId
     * @return
     */
    URL getObjectNetUrl(String workspaceId, String waylineId) throws SQLException;
    /**
     * Save the basic information of the wayline file.
     * @param workspaceId
     * @param metadata
     * @return
     */
    Integer saveWaylineFile(String workspaceId, WaylineFileDTO metadata);

    /**
     * Updates whether the file is collected or not based on the passed parameters.
     * @param workspaceId
     * @param ids          wayline id
     * @param isFavorite   Whether the wayline file is favorited or not.
     * @return
     */
    Boolean markFavorite(String workspaceId, List<String> ids, Boolean isFavorite);

    /**
     * Batch query for duplicate file names in workspace.
     * @param workspaceId
     * @param names
     * @return
     */
    List<String> getDuplicateNames(String workspaceId, List<String> names);

    /**
     * Delete the wayline file based on the wayline id.
     * @param workspaceId
     * @param waylineId
     */
    Boolean deleteByWaylineId(String workspaceId, String waylineId);

    /**
     * Delete the wayline file based on the wayline id.
     * @param workspaceId
     * @param ids
     * @param waylineIds
     */
    Boolean deleteBatchByIdOrWaylineId(String workspaceId, List<String> ids, List<String> waylineIds);

    /**
     * Import kmz wayline file.
     * @param file
     * @param workspaceId
     * @param creator
     * @return
     */
    void importKmzFile(MultipartFile file, String workspaceId, String creator);

    /**
     * Import kmz wayline file.
     * @param file
     * @param workspaceId
     * @param creator
     * @param fileParentId
     * @return
     */
    void importKmzFile(MultipartFile file, String workspaceId, String creator, String fileParentId);
    /**
     * add directory
     * @param workspaceId
     * @param waylineFileDTO
     * @return
     */
    Integer addDirectory(String workspaceId, WaylineFileDTO waylineFileDTO);

    /**
     * get directory tree
     * @param workspaceId
     */
    List<WaylineFileTreeVO> getDirectoryTree(String workspaceId);

    /**
     * get directory tree    List<WaylineFileTreeVO> getDirectoryTree(String workspaceId);
     * @param workspaceId
     */
    List<WaylineFileTreeVO> getWaylineFileTree(String workspaceId, String waylineFileId);

    /**
     * update file parentId
     * @param waylineFileId
     * @param parentId
     */
    boolean updateParentId(String waylineFileId, String parentId);

    /**
     * batch update file parentId
     * @param waylineFileIds
     * @param parentId
     * @return
     */
    boolean updateParentIdBatch(String waylineFileIds, String parentId);

    /**
     * batch update file parentId
     * @param waylineFileIds
     * @param parentId
     * @return
     */
    boolean updateParentIdBatch(List<String> waylineFileIds, String parentId);

    /**
     * del waylineFile with child
     * @param workspaceId
     * @param waylineFileId
     * @return
     */
    boolean deleteDirectory(String workspaceId, String waylineFileId);

    PaginationData<GetWaylineListResponse> getWaylinesByParam(String workspaceId, String parentId, GetWaylineListRequest param);

    PaginationData<GetWaylineListResponse> getWaylinesByParam(WaylineSearchParam param, String workspaceId, GetWaylineListRequest request);

}
